/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.lang.DisplayNameSettings;
import edu.stanford.protege.webprotege.project.AutoValue_ProjectDetails;
import edu.stanford.protege.webprotege.project.HasProjectId;
import edu.stanford.protege.webprotege.projectsettings.EntityDeprecationSettings;
import java.io.Serializable;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class ProjectDetails
implements Serializable,
Comparable<ProjectDetails>,
HasProjectId {
    public static final String PROJECT_ID = "_id";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String OWNER = "owner";
    public static final String IN_TRASH = "inTrash";
    public static final String CREATED_AT = "createdAt";
    public static final String CREATED_BY = "createdBy";
    public static final String MODIFIED_AT = "modifiedAt";
    public static final String MODIFIED_BY = "modifiedBy";
    public static final String DEFAULT_LANGUAGE = "defaultLanguage";
    public static final String DEFAULT_DISPLAY_NAME_SETTINGS = "defaultDisplayNameSettings";
    public static final String ENTITY_DEPRECATION_SETTINGS = "entityDeprecationSettings";

    public static ProjectDetails get(@Nonnull ProjectId projectId, @Nonnull String displayName, @Nonnull String description, @Nonnull UserId owner, boolean inTrash, @Nonnull DictionaryLanguage dictionaryLanguage, @Nonnull DisplayNameSettings displayNameSettings, long createdAt, @Nonnull UserId createdBy, long lastModifiedAt, @Nonnull UserId lastModifiedBy, @Nonnull EntityDeprecationSettings entityDeprecationSettings) {
        return new AutoValue_ProjectDetails(projectId, displayName, description, owner, inTrash, dictionaryLanguage, displayNameSettings, createdAt, createdBy, lastModifiedAt, lastModifiedBy, entityDeprecationSettings);
    }

    @JsonCreator
    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public static ProjectDetails valueOf(@Nonnull @JsonProperty(value="_id") ProjectId projectId, @Nonnull @JsonProperty(value="displayName") String displayName, @Nullable @JsonProperty(value="description") String description, @Nonnull @JsonProperty(value="owner") UserId owner, @JsonProperty(value="inTrash") boolean inTrash, @Nullable @JsonProperty(value="defaultLanguage") DictionaryLanguage dictionaryLanguage, @Nullable @JsonProperty(value="defaultDisplayNameSettings") DisplayNameSettings displayNameSettings, @JsonProperty(value="createdAt") Instant createdAt, @JsonProperty(value="createdBy") @Nonnull UserId createdBy, @JsonProperty(value="modifiedAt") Instant lastModifiedAt, @JsonProperty(value="modifiedBy") @Nonnull UserId lastModifiedBy, @JsonProperty(value="entityDeprecationSettings") @Nullable EntityDeprecationSettings entityDeprecationSettings) {
        String desc = description == null ? "" : description;
        DictionaryLanguage dl = dictionaryLanguage == null ? DictionaryLanguage.rdfsLabel((String)"") : dictionaryLanguage;
        DisplayNameSettings dns = displayNameSettings == null ? DisplayNameSettings.empty() : displayNameSettings;
        EntityDeprecationSettings eds = entityDeprecationSettings == null ? EntityDeprecationSettings.empty() : entityDeprecationSettings;
        return ProjectDetails.get(projectId, displayName, desc, owner, inTrash, dl, dns, createdAt.toEpochMilli(), createdBy, lastModifiedAt.toEpochMilli(), lastModifiedBy, eds);
    }

    public ProjectDetails withDisplayName(@Nonnull String displayName) {
        if (displayName.equals(this.getDisplayName())) {
            return this;
        }
        return ProjectDetails.get(this.projectId(), displayName, this.getDescription(), this.getOwner(), this.isInTrash(), this.getDefaultDictionaryLanguage(), this.getDefaultDisplayNameSettings(), this.getCreatedAt(), this.getCreatedBy(), this.getLastModifiedAt(), this.getLastModifiedBy(), this.getEntityDeprecationSettings());
    }

    public ProjectDetails withDescription(@Nonnull String description) {
        if (description.equals(this.getDescription())) {
            return this;
        }
        return ProjectDetails.get(this.projectId(), this.getDisplayName(), description, this.getOwner(), this.isInTrash(), this.getDefaultDictionaryLanguage(), this.getDefaultDisplayNameSettings(), this.getCreatedAt(), this.getCreatedBy(), this.getLastModifiedAt(), this.getLastModifiedBy(), this.getEntityDeprecationSettings());
    }

    public ProjectDetails withDefaultLanguage(@Nonnull DictionaryLanguage defaultLanguage) {
        if (defaultLanguage.equals(this.getDefaultDictionaryLanguage())) {
            return this;
        }
        return ProjectDetails.get(this.projectId(), this.getDisplayName(), this.getDescription(), this.getOwner(), this.isInTrash(), defaultLanguage, this.getDefaultDisplayNameSettings(), this.getCreatedAt(), this.getCreatedBy(), this.getLastModifiedAt(), this.getLastModifiedBy(), this.getEntityDeprecationSettings());
    }

    public ProjectDetails withDefaultDisplayNameSettings(@Nonnull DisplayNameSettings defaultDisplayNameSettings) {
        if (defaultDisplayNameSettings.equals(this.getDefaultDisplayNameSettings())) {
            return this;
        }
        return ProjectDetails.get(this.projectId(), this.getDisplayName(), this.getDescription(), this.getOwner(), this.isInTrash(), this.getDefaultDictionaryLanguage(), defaultDisplayNameSettings, this.getCreatedAt(), this.getCreatedBy(), this.getLastModifiedAt(), this.getLastModifiedBy(), this.getEntityDeprecationSettings());
    }

    public ProjectDetails withInTrash(boolean inTrash) {
        if (inTrash == this.isInTrash()) {
            return this;
        }
        return ProjectDetails.get(this.projectId(), this.getDisplayName(), this.getDescription(), this.getOwner(), inTrash, this.getDefaultDictionaryLanguage(), this.getDefaultDisplayNameSettings(), this.getCreatedAt(), this.getCreatedBy(), this.getLastModifiedAt(), this.getLastModifiedBy(), this.getEntityDeprecationSettings());
    }

    @Nonnull
    public ProjectDetails withEntityDeprecationSettings(@Nonnull EntityDeprecationSettings settings) {
        Preconditions.checkNotNull((Object)settings);
        return ProjectDetails.get(this.projectId(), this.getDisplayName(), this.getDescription(), this.getOwner(), this.isInTrash(), this.getDefaultDictionaryLanguage(), this.getDefaultDisplayNameSettings(), this.getCreatedAt(), this.getCreatedBy(), this.getLastModifiedAt(), this.getLastModifiedBy(), settings);
    }

    @Override
    @JsonProperty(value="_id")
    @Nonnull
    public abstract ProjectId projectId();

    @JsonProperty(value="displayName")
    @Nonnull
    public abstract String getDisplayName();

    @JsonProperty(value="description")
    @Nonnull
    public abstract String getDescription();

    @JsonProperty(value="owner")
    @Nonnull
    public abstract UserId getOwner();

    @JsonProperty(value="inTrash")
    public abstract boolean isInTrash();

    @JsonIgnore
    public boolean isNotInTrash() {
        return !this.isInTrash();
    }

    @JsonProperty(value="defaultLanguage")
    @Nonnull
    public abstract DictionaryLanguage getDefaultDictionaryLanguage();

    @JsonProperty(value="defaultDisplayNameSettings")
    @Nonnull
    public abstract DisplayNameSettings getDefaultDisplayNameSettings();

    @JsonIgnore
    public abstract long getCreatedAt();

    @JsonProperty(value="createdAt")
    protected Instant createdAt() {
        return Instant.ofEpochMilli(this.getCreatedAt());
    }

    @JsonProperty(value="createdBy")
    @Nonnull
    public abstract UserId getCreatedBy();

    @JsonIgnore
    public abstract long getLastModifiedAt();

    @JsonProperty(value="modifiedAt")
    protected Instant modifiedAt() {
        return Instant.ofEpochMilli(this.getLastModifiedAt());
    }

    @Nonnull
    @JsonProperty(value="modifiedBy")
    public abstract UserId getLastModifiedBy();

    @Nonnull
    @JsonProperty(value="entityDeprecationSettings")
    public abstract EntityDeprecationSettings getEntityDeprecationSettings();

    @Override
    public int compareTo(ProjectDetails o) {
        int dispNameDiff = this.getDisplayName().compareToIgnoreCase(o.getDisplayName());
        if (dispNameDiff != 0) {
            return dispNameDiff;
        }
        int caseSensitiveDiff = this.getDisplayName().compareTo(o.getDisplayName());
        if (caseSensitiveDiff != 0) {
            return caseSensitiveDiff;
        }
        int ownerDiff = this.getOwner().compareTo(o.getOwner());
        if (ownerDiff != 0) {
            return ownerDiff;
        }
        int descriptionDiff = this.getDescription().compareTo(o.getDescription());
        if (descriptionDiff != 0) {
            return descriptionDiff;
        }
        return this.projectId().id().compareTo(o.projectId().id());
    }
}

