/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.projectsettings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.lang.DisplayNameSettings;
import edu.stanford.protege.webprotege.project.WithProjectId;
import edu.stanford.protege.webprotege.projectsettings.AutoValue_ProjectSettings;
import edu.stanford.protege.webprotege.projectsettings.EntityDeprecationSettings;
import edu.stanford.protege.webprotege.projectsettings.SlackIntegrationSettings;
import edu.stanford.protege.webprotege.projectsettings.WebhookSettings;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class ProjectSettings
implements Serializable,
WithProjectId<ProjectSettings> {
    private static final String PROJECT_ID = "projectId";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DESCRIPTION = "description";
    private static final String DEFAULT_LANGUAGE = "defaultLanguage";
    private static final String DEFAULT_DISPLAY_NAME_SETTINGS = "defaultDisplayNameSettings";
    private static final String SLACK_INTEGRATION_SETTINGS = "slackIntegrationSettings";
    private static final String WEBHOOK_SETTINGS = "webhookSettings";
    private static final String ENTITY_DEPRECATION_SETTINGS = "entityDeprecationSettings";

    @JsonProperty(value="projectId")
    @Nonnull
    public abstract ProjectId getProjectId();

    @Nonnull
    @JsonProperty(value="displayName")
    public abstract String getProjectDisplayName();

    @Nonnull
    @JsonProperty(value="description")
    public abstract String getProjectDescription();

    @Nonnull
    @JsonProperty(value="defaultLanguage")
    public abstract DictionaryLanguage getDefaultLanguage();

    @Nonnull
    @JsonProperty(value="defaultDisplayNameSettings")
    public abstract DisplayNameSettings getDefaultDisplayNameSettings();

    @Nonnull
    @JsonProperty(value="slackIntegrationSettings")
    public abstract SlackIntegrationSettings getSlackIntegrationSettings();

    @Nonnull
    @JsonProperty(value="webhookSettings")
    public abstract WebhookSettings getWebhookSettings();

    @Nonnull
    @JsonProperty(value="entityDeprecationSettings")
    public abstract EntityDeprecationSettings getEntityDeprecationSettings();

    @Nonnull
    @JsonCreator
    public static ProjectSettings get(@Nonnull @JsonProperty(value="projectId") ProjectId projectId, @Nonnull @JsonProperty(value="displayName") String displayName, @Nonnull @JsonProperty(value="description") String description, @Nonnull @JsonProperty(value="defaultLanguage") DictionaryLanguage defaultLanguage, @Nonnull @JsonProperty(value="defaultDisplayNameSettings") DisplayNameSettings defaultDisplayNameSettings, @Nonnull @JsonProperty(value="slackIntegrationSettings") SlackIntegrationSettings slackIntegrationSettings, @Nonnull @JsonProperty(value="webhookSettings") WebhookSettings webhookSettings, @Nullable @JsonProperty(value="entityDeprecationSettings") EntityDeprecationSettings entityDeprecationSettings) {
        return new AutoValue_ProjectSettings(projectId, displayName, description, defaultLanguage, defaultDisplayNameSettings, slackIntegrationSettings, webhookSettings, entityDeprecationSettings == null ? EntityDeprecationSettings.empty() : entityDeprecationSettings);
    }

    @Override
    public ProjectSettings withProjectId(@Nonnull ProjectId projectId) {
        return ProjectSettings.get(projectId, this.getProjectDisplayName(), this.getProjectDescription(), this.getDefaultLanguage(), this.getDefaultDisplayNameSettings(), this.getSlackIntegrationSettings(), this.getWebhookSettings(), this.getEntityDeprecationSettings());
    }
}

