/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.viz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.criteria.MultiMatchType;
import edu.stanford.protege.webprotege.viz.AnyEdgeCriteria;
import edu.stanford.protege.webprotege.viz.AutoValue_CompositeEdgeCriteria;
import edu.stanford.protege.webprotege.viz.EdgeCriteria;
import edu.stanford.protege.webprotege.viz.EdgeCriteriaVisitor;
import edu.stanford.protege.webprotege.viz.NoEdgeCriteria;
import java.util.List;
import javax.annotation.Nonnull;

@JsonTypeName(value="CompositeOf")
@AutoValue
public abstract class CompositeEdgeCriteria
implements EdgeCriteria {
    @JsonCreator
    @Nonnull
    public static CompositeEdgeCriteria get(@Nonnull @JsonProperty(value="criteria") List<? extends EdgeCriteria> criteria, @Nonnull @JsonProperty(value="matchType") MultiMatchType multiMatchType) {
        return new AutoValue_CompositeEdgeCriteria((ImmutableList<EdgeCriteria>)ImmutableList.copyOf(criteria), multiMatchType);
    }

    @Nonnull
    public static CompositeEdgeCriteria get(@Nonnull MultiMatchType multiMatchType, EdgeCriteria ... criteria) {
        return CompositeEdgeCriteria.get((List<? extends EdgeCriteria>)ImmutableList.copyOf((Object[])criteria), multiMatchType);
    }

    @Nonnull
    public static CompositeEdgeCriteria anyEdge() {
        return CompositeEdgeCriteria.get((List<? extends EdgeCriteria>)ImmutableList.of((Object)AnyEdgeCriteria.get()), MultiMatchType.ANY);
    }

    @Nonnull
    public static CompositeEdgeCriteria noEdge() {
        return CompositeEdgeCriteria.get((List<? extends EdgeCriteria>)ImmutableList.of((Object)NoEdgeCriteria.get()), MultiMatchType.ANY);
    }

    @Override
    public <R> R accept(@Nonnull EdgeCriteriaVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Nonnull
    public abstract ImmutableList<EdgeCriteria> getCriteria();

    @Nonnull
    public abstract MultiMatchType getMatchType();

    @Override
    @Nonnull
    public EdgeCriteria simplify() {
        ImmutableList simplified = (ImmutableList)this.getCriteria().stream().map(EdgeCriteria::simplify).filter(c -> !(c instanceof AnyEdgeCriteria)).collect(ImmutableList.toImmutableList());
        if (simplified.size() == 0) {
            return AnyEdgeCriteria.get();
        }
        if (simplified.size() == 1) {
            return (EdgeCriteria)simplified.get(0);
        }
        return CompositeEdgeCriteria.get((List<? extends EdgeCriteria>)simplified, this.getMatchType());
    }
}

