/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.hierarchy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.entity.EntityNode;
import javax.annotation.Nonnull;

public class GraphNode<U> {
    private final U userObject;
    private final boolean sink;

    public GraphNode(@Nonnull U userObject) {
        this(userObject, false);
    }

    public GraphNode(@Nonnull U userObject, boolean sink) {
        this.userObject = Preconditions.checkNotNull(userObject);
        this.sink = sink;
    }

    @JsonCreator
    public static GraphNode<EntityNode> getForEntityNode(@JsonProperty(value="userObject") @Nonnull EntityNode userObject, @JsonProperty(value="sink", defaultValue="false") boolean sink) {
        return new GraphNode<EntityNode>(userObject, sink);
    }

    public static <U> GraphNode<U> get(@Nonnull U userObject) {
        return new GraphNode<U>(userObject);
    }

    public static <U> GraphNode get(@Nonnull U userObject, boolean sink) {
        return new GraphNode<U>(userObject, sink);
    }

    @Nonnull
    public U getUserObject() {
        return this.userObject;
    }

    public boolean isSink() {
        return this.sink;
    }

    public int hashCode() {
        return this.userObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GraphNode)) {
            return false;
        }
        GraphNode other = (GraphNode)obj;
        return this.userObject.equals(other.userObject);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GraphNode").addValue(this.userObject).toString();
    }
}

