/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.UUIDUtil;
import edu.stanford.protege.webprotege.search.AutoValue_EntitySearchFilterId;
import java.util.UUID;
import javax.annotation.Nonnull;

@AutoValue
public abstract class EntitySearchFilterId {
    @JsonCreator
    @Nonnull
    public static EntitySearchFilterId get(@Nonnull String id) {
        if (!UUIDUtil.isWellFormed((String)((String)Preconditions.checkNotNull((Object)id)))) {
            throw new IllegalArgumentException("Malformed filter id: " + id);
        }
        return new AutoValue_EntitySearchFilterId(id);
    }

    @Nonnull
    public static EntitySearchFilterId createFilterId() {
        return EntitySearchFilterId.get(UUID.randomUUID().toString());
    }

    @JsonValue
    @Nonnull
    public abstract String getId();
}

