/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.viz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.viz.AutoValue_RelationshipEdge;
import edu.stanford.protege.webprotege.viz.Edge;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonTypeName(value="Relationship")
@AutoValue
public abstract class RelationshipEdge
implements Edge {
    @JsonCreator
    @Nonnull
    public static RelationshipEdge get(@JsonProperty(value="tail") @Nonnull OWLEntityData tail, @JsonProperty(value="head") @Nonnull OWLEntityData head, @JsonProperty(value="relationship") @Nonnull OWLEntityData relationship) {
        return new AutoValue_RelationshipEdge(head, tail, relationship);
    }

    @Nonnull
    public abstract OWLEntityData getRelationship();

    @Override
    public String getRelationshipDescriptor() {
        return this.getRelationship().getEntity().getIRI().toString();
    }

    @Override
    @Nonnull
    public String getLabel() {
        return this.getRelationship().getBrowserText();
    }

    @Override
    public boolean isIsA() {
        return false;
    }

    @Override
    public boolean isRelationship() {
        return true;
    }

    @Override
    public Optional<OWLEntityData> getLabellingEntity() {
        return Optional.of(this.getRelationship());
    }
}

