/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.color;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.stanford.protege.webprotege.color.AutoValue_Color;
import javax.annotation.Nonnull;

@AutoValue
public abstract class Color {
    private static final int MIN = 0;
    private static final int MAX = 255;
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String BLUE = "blue";

    public static Color get(int red, int green, int blue) {
        Preconditions.checkArgument((red >= 0 && red <= 255 ? 1 : 0) != 0, (Object)"Invalid value specified for red component");
        Preconditions.checkArgument((green >= 0 && green <= 255 ? 1 : 0) != 0, (Object)"Invalid value specified for red component");
        Preconditions.checkArgument((blue >= 0 && blue <= 255 ? 1 : 0) != 0, (Object)"Invalid value specified for red component");
        return new AutoValue_Color(red, green, blue);
    }

    public static Color getRGB(int red, int green, int blue) {
        return Color.get(red, green, blue);
    }

    @JsonCreator
    @Nonnull
    public static Color getHex(@Nonnull String hexValue) {
        Preconditions.checkNotNull((Object)hexValue);
        Preconditions.checkArgument((hexValue.length() == 7 ? 1 : 0) != 0, (Object)"Invalid hex value (incorrect length)");
        Preconditions.checkArgument((boolean)hexValue.startsWith("#"), (Object)"Invalid hex value (values should start with #)");
        for (int i = 1; i < hexValue.length(); ++i) {
            char ch = hexValue.charAt(i);
            Preconditions.checkArgument((ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' ? 1 : 0) != 0, (Object)("Invalid hex value (illegal character at index " + i + ")"));
        }
        return Color.getHex(hexValue.substring(1, 3), hexValue.substring(3, 5), hexValue.substring(5, 7));
    }

    public static Color getHex(@Nonnull String red, @Nonnull String green, @Nonnull String blue) {
        Preconditions.checkNotNull((Object)red);
        Preconditions.checkNotNull((Object)green);
        Preconditions.checkNotNull((Object)blue);
        Preconditions.checkArgument((red.length() == 2 ? 1 : 0) != 0, (Object)"Invalid length for red hex component");
        Preconditions.checkArgument((green.length() == 2 ? 1 : 0) != 0, (Object)"Invalid length for green hex component");
        Preconditions.checkArgument((blue.length() == 2 ? 1 : 0) != 0, (Object)"Invalid length for blue hex component");
        return Color.get(Integer.parseInt(red, 16), Integer.parseInt(green, 16), Integer.parseInt(blue, 16));
    }

    public static Color getHSL(double hue, double saturation, double lightness) {
        double b1;
        double g1;
        double r1;
        Preconditions.checkArgument((0.0 <= hue && hue <= 360.0 ? 1 : 0) != 0, (Object)"hue must be a value from 0 to 360");
        Preconditions.checkArgument((0.0 <= saturation && saturation <= 1.0 ? 1 : 0) != 0, (Object)"saturation must be a value from 0 to 1");
        Preconditions.checkArgument((0.0 <= lightness && lightness <= 1.0 ? 1 : 0) != 0, (Object)"lightness must be a value from 0 to 1");
        double c = (1.0 - Math.abs(2.0 * lightness - 1.0)) * saturation;
        double hp = hue / 60.0;
        double x = c * (1.0 - Math.abs(hp % 2.0 - 1.0));
        if (hp <= 1.0) {
            r1 = c;
            g1 = x;
            b1 = 0.0;
        } else if (hp <= 2.0) {
            r1 = x;
            g1 = c;
            b1 = 0.0;
        } else if (hp <= 3.0) {
            r1 = 0.0;
            g1 = c;
            b1 = x;
        } else if (hp <= 4.0) {
            r1 = 0.0;
            g1 = x;
            b1 = c;
        } else if (hp <= 5.0) {
            r1 = x;
            g1 = 0.0;
            b1 = c;
        } else {
            r1 = c;
            g1 = 0.0;
            b1 = x;
        }
        double m = lightness - 0.5 * c;
        int r = (int)((r1 + m) * 255.0);
        int g = (int)((g1 + m) * 255.0);
        int b = (int)((b1 + m) * 255.0);
        return Color.getRGB(r, g, b);
    }

    public static Color getWhite() {
        return Color.getRGB(255, 255, 255);
    }

    public abstract int getRed();

    public abstract int getGreen();

    public abstract int getBlue();

    @Nonnull
    @JsonValue
    public String getHex() {
        String r = Color.pad(Integer.toHexString(this.getRed()));
        String g = Color.pad(Integer.toHexString(this.getGreen()));
        String b = Color.pad(Integer.toHexString(this.getBlue()));
        return "#" + r + g + b;
    }

    private static String pad(String hexValue) {
        return Strings.padStart((String)hexValue, (int)2, (char)'0');
    }
}

