/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.hierarchy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import edu.stanford.protege.webprotege.hierarchy.GraphNode;
import java.io.Serializable;

public class GraphEdge<U>
implements Serializable {
    private final GraphNode<U> predecessor;
    private final GraphNode<U> successor;

    @JsonCreator
    public GraphEdge(@JsonProperty(value="predecessor") GraphNode<U> predecessor, @JsonProperty(value="successor") GraphNode<U> successor) {
        this.predecessor = predecessor;
        this.successor = successor;
    }

    public GraphNode<U> getPredecessor() {
        return this.predecessor;
    }

    public GraphNode<U> getSuccessor() {
        return this.successor;
    }

    public int hashCode() {
        return "GraphEdge".hashCode() + this.predecessor.hashCode() + 13 * this.successor.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphEdge)) {
            return false;
        }
        GraphEdge other = (GraphEdge)o;
        return this.predecessor.equals(other.predecessor) && this.successor.equals(other.getSuccessor());
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Edge").add("predecessor", this.predecessor).add("successor", this.successor).toString();
    }
}

