/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.issues;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Milestone {
    @Nonnull
    private String label;

    private Milestone() {
    }

    public Milestone(@Nonnull String label) {
        this.label = (String)Preconditions.checkNotNull((Object)label);
        Preconditions.checkArgument((!label.isEmpty() ? 1 : 0) != 0, (Object)"Milestone label must not be empty");
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        return Objects.hashCode(this.label);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Milestone)) {
            return false;
        }
        Milestone other = (Milestone)obj;
        return this.label.equals(other.label);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Milestone").addValue((Object)this.label).toString();
    }
}

