/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.merge;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.merge.Diff;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyDiff {
    private OWLOntologyID fromOntologyId;
    private OWLOntologyID toOntologyId;
    private Diff<OWLAnnotation> annotationDiff;
    private Diff<OWLAxiom> axiomDiff;

    private OntologyDiff() {
    }

    public OntologyDiff(OWLOntologyID fromOntologyId, OWLOntologyID toOntologyId, Diff<OWLAnnotation> annotationDiff, Diff<OWLAxiom> axiomDiff) {
        this.fromOntologyId = (OWLOntologyID)Preconditions.checkNotNull((Object)fromOntologyId);
        this.toOntologyId = (OWLOntologyID)Preconditions.checkNotNull((Object)toOntologyId);
        this.annotationDiff = (Diff)Preconditions.checkNotNull(annotationDiff);
        this.axiomDiff = (Diff)Preconditions.checkNotNull(axiomDiff);
    }

    public OWLOntologyID getFromOntologyId() {
        return this.fromOntologyId;
    }

    public OWLOntologyID getToOntologyId() {
        return this.toOntologyId;
    }

    public boolean isEmpty() {
        return this.annotationDiff.isEmpty() && this.axiomDiff.isEmpty();
    }

    public Diff<OWLAnnotation> getAnnotationDiff() {
        return this.annotationDiff;
    }

    public Diff<OWLAxiom> getAxiomDiff() {
        return this.axiomDiff;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fromOntologyId, this.toOntologyId, this.annotationDiff, this.axiomDiff});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OntologyDiff)) {
            return false;
        }
        OntologyDiff other = (OntologyDiff)obj;
        return this.fromOntologyId.equals((Object)other.fromOntologyId) && this.toOntologyId.equals((Object)other.toOntologyId) && this.annotationDiff.equals(other.annotationDiff) && this.axiomDiff.equals(other.axiomDiff);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OntologyDiff").addValue((Object)this.fromOntologyId).addValue((Object)this.toOntologyId).addValue(this.annotationDiff).addValue(this.axiomDiff).toString();
    }
}

