/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.perspective;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.perspective.NodeVisitor;
import edu.stanford.protege.webprotege.perspective.ParentNode;
import edu.stanford.protege.webprotege.perspective.TerminalNode;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

@JsonSubTypes(value={@JsonSubTypes.Type(value=TerminalNode.class), @JsonSubTypes.Type(value=ParentNode.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
public abstract class Node {
    @Nullable
    private ParentNode parent = null;

    protected Node() {
    }

    public abstract <O> O accept(NodeVisitor<O> var1);

    public abstract Node duplicate();

    public abstract Set<TerminalNode> getTerminalNodes();

    @JsonIgnore
    public abstract boolean isIsometricWith(Node var1);

    public abstract boolean equalsIgnoreWeights(Node var1);

    @JsonIgnore
    public abstract boolean isParentNode();

    public abstract Node minimise();

    @JsonIgnore
    public Optional<ParentNode> getParent() {
        return Optional.ofNullable(this.parent);
    }

    protected void setParent(Optional<ParentNode> parent) {
        this.parent = ((Optional)Preconditions.checkNotNull(parent)).orElse(null);
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }
}

