/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.perspective;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.perspective.Direction;
import edu.stanford.protege.webprotege.perspective.Node;
import edu.stanford.protege.webprotege.perspective.NodeVisitor;
import edu.stanford.protege.webprotege.perspective.TerminalNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class ParentNode
extends Node {
    private final Direction direction;
    private final List<NodeHolder> children = new ArrayList<NodeHolder>();

    public ParentNode() {
        this(Direction.getDefaultDirection());
    }

    public ParentNode(Direction direction) {
        this.direction = (Direction)((Object)Preconditions.checkNotNull((Object)((Object)direction)));
    }

    @JsonCreator
    protected ParentNode(@JsonProperty(value="direction") Direction direction, @JsonProperty(value="children") List<NodeHolder> children) {
        this.direction = (Direction)((Object)Preconditions.checkNotNull((Object)((Object)direction)));
        this.children.addAll(children);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ParentNode");
        helper.add("direction", (Object)this.direction);
        for (NodeHolder nodeHolder : this.children) {
            helper.add("weight", nodeHolder.getWeight());
            helper.addValue((Object)nodeHolder.getNode());
        }
        return helper.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentNode)) {
            return false;
        }
        ParentNode other = (ParentNode)o;
        return this.getDirection() == other.getDirection() && this.children.equals(other.children);
    }

    @Override
    public boolean equalsIgnoreWeights(Node o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentNode)) {
            return false;
        }
        ParentNode other = (ParentNode)o;
        if (this.getDirection() != other.getDirection()) {
            return false;
        }
        int childCount = this.getChildCount();
        if (childCount != other.getChildCount()) {
            return false;
        }
        for (int i = 0; i < childCount; ++i) {
            Node otherChild;
            Node myChild = this.getChildAt(i);
            if (myChild.equalsIgnoreWeights(otherChild = other.getChildAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return "ParentNode".hashCode() + this.direction.hashCode() + this.children.hashCode();
    }

    @Override
    public <O> O accept(NodeVisitor<O> visitor) {
        return visitor.visit(this);
    }

    public Node getChildAt(int index) {
        return this.children.get(index).getNode();
    }

    @JsonIgnore
    public int getChildCount() {
        return this.children.size();
    }

    @Nonnull
    public List<NodeHolder> getChildren() {
        return new ArrayList<NodeHolder>(this.children);
    }

    @Override
    @JsonIgnore
    public Set<TerminalNode> getTerminalNodes() {
        HashSet<TerminalNode> result = new HashSet<TerminalNode>();
        for (NodeHolder holder : this.children) {
            result.addAll(holder.getNode().getTerminalNodes());
        }
        return result;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @JsonIgnore
    public double getTotalWeight() {
        double result = 0.0;
        for (NodeHolder wn : this.children) {
            result += wn.getWeight();
        }
        return result;
    }

    public double getWeightAt(int index) {
        return this.children.get(index).getWeight();
    }

    public void setWeightAt(int index, double weight) {
        this.children.get(index).setWeight(weight);
    }

    @Override
    public boolean isIsometricWith(Node otherNode) {
        if (otherNode == this) {
            return true;
        }
        if (!(otherNode instanceof ParentNode)) {
            return false;
        }
        ParentNode otherParent = (ParentNode)otherNode;
        if (this.getDirection() != otherParent.getDirection()) {
            return false;
        }
        int childCount = this.getChildCount();
        if (childCount != otherParent.getChildCount()) {
            return false;
        }
        for (int i = 0; i < childCount; ++i) {
            Node otherChild;
            double otherChildWeight;
            double myChildWeight = this.getWeightAt(i);
            if (myChildWeight != (otherChildWeight = otherParent.getWeightAt(i))) {
                return false;
            }
            Node myChild = this.getChildAt(i);
            if (myChild.isIsometricWith(otherChild = otherParent.getChildAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @JsonIgnore
    public boolean isParentNode() {
        return true;
    }

    public void addChild(Node child, double weight) {
        Preconditions.checkArgument((weight >= 0.0 ? 1 : 0) != 0);
        this.children.add(new NodeHolder((Node)Preconditions.checkNotNull((Object)child), weight));
        child.setParent(Optional.of(this));
    }

    public void removeChild(Node child) {
        int index = this.indexOf(child);
        if (index != -1) {
            this.children.remove(index);
            child.setParent(Optional.empty());
        }
    }

    @Override
    @JsonIgnore
    public ParentNode duplicate() {
        ParentNode parentNode = new ParentNode(this.direction);
        for (NodeHolder child : this.children) {
            Node childDuplicate = child.getNode().duplicate();
            parentNode.addChild(childDuplicate, child.getWeight());
        }
        return parentNode;
    }

    @Override
    public Node minimise() {
        if (this.children.size() == 1) {
            return this.getFirstNodeMinimised();
        }
        return this.minimiseAllChildren();
    }

    public void replaceWith(TerminalNode node, Direction direction, TerminalNode ... replacementNodes) {
        int index = this.indexOf(node);
        if (index == -1) {
            return;
        }
        ParentNode newParentNode = new ParentNode(direction);
        newParentNode.setParent(Optional.of(this));
        this.children.set(index, new NodeHolder(newParentNode, this.getWeightAt(index)));
        for (TerminalNode tn : replacementNodes) {
            double weight = 1.0 / (double)replacementNodes.length;
            newParentNode.addChild(tn, weight);
        }
        this.minimise();
    }

    protected int indexOf(Node child) {
        for (int i = 0; i < this.children.size(); ++i) {
            Node node = this.children.get(i).getNode();
            if (!node.equals(child)) continue;
            return i;
        }
        return -1;
    }

    @JsonIgnore
    @Nonnull
    private Node getFirstNodeMinimised() {
        return this.children.get(0).getNode().minimise();
    }

    private Node minimiseAllChildren() {
        ArrayList<NodeHolder> currentChildren = new ArrayList<NodeHolder>(this.children);
        double currentTotalWeight = this.getTotalWeight();
        this.children.clear();
        for (NodeHolder child : currentChildren) {
            double childWeight;
            Node existingChild = child.getNode();
            Node minimisedChild = existingChild.minimise();
            if (minimisedChild.isParentNode() && ((ParentNode)minimisedChild).getDirection() == this.getDirection()) {
                childWeight = child.getWeight();
                double weightProportion = childWeight / currentTotalWeight;
                ParentNode node = (ParentNode)minimisedChild;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    Node grandChildNode = node.getChildAt(i);
                    double grandChildWeight = node.getWeightAt(i);
                    double reProportionedWeight = grandChildWeight * weightProportion;
                    this.addChild(grandChildNode, reProportionedWeight);
                }
                minimisedChild.setParent(Optional.empty());
                continue;
            }
            childWeight = child.getWeight();
            this.addChild(minimisedChild, childWeight);
        }
        return this;
    }

    @JsonPropertyOrder(value={"weight", "node"})
    public static class NodeHolder {
        static final String NODE = "node";
        static final String WEIGHT = "weight";
        private Node node;
        private double weight;

        private NodeHolder() {
        }

        @JsonCreator
        private NodeHolder(@JsonProperty(value="node") Node node, @JsonProperty(value="weight") double weight) {
            this.node = node;
            this.weight = weight;
        }

        @JsonProperty(value="node")
        public Node getNode() {
            return this.node;
        }

        @JsonProperty(value="weight")
        public double getWeight() {
            return this.weight;
        }

        private void setWeight(double weight) {
            this.weight = weight;
        }

        public int hashCode() {
            return "NodeHolder".hashCode() + this.node.hashCode() + (int)this.weight * 100;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeHolder)) {
                return false;
            }
            NodeHolder other = (NodeHolder)o;
            return this.node.equals(other.node) && this.weight == other.weight;
        }
    }
}

