/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.perspective;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.perspective.AutoValue_PerspectiveCoordinates;
import edu.stanford.protege.webprotege.perspective.PerspectiveId;
import edu.stanford.protege.webprotege.project.WithProjectId;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class PerspectiveCoordinates
implements WithProjectId<PerspectiveCoordinates> {
    public static final String PROJECT_ID = "projectId";
    public static final String USER_ID = "userId";
    public static final String PERSPECTIVE_ID = "perspectiveId";

    @Nonnull
    public static PerspectiveCoordinates get(@Nonnull ProjectId projectId, @Nonnull UserId userId, @Nonnull PerspectiveId perspectiveId) {
        return PerspectiveCoordinates.getInternal(projectId, userId, perspectiveId);
    }

    @Nonnull
    public static PerspectiveCoordinates get(@Nonnull ProjectId projectId, @Nonnull PerspectiveId perspectiveId) {
        return PerspectiveCoordinates.getInternal(projectId, null, perspectiveId);
    }

    @Nonnull
    public static PerspectiveCoordinates get(@Nonnull PerspectiveId perspectiveId) {
        return PerspectiveCoordinates.getInternal(null, null, perspectiveId);
    }

    @Nonnull
    protected static PerspectiveCoordinates getInternal(@JsonProperty(value="projectId") @Nullable ProjectId projectId, @JsonProperty(value="userId") @Nullable UserId userId, @JsonProperty(value="perspectiveId") @Nullable PerspectiveId perspectiveId) {
        return new AutoValue_PerspectiveCoordinates(projectId, userId, perspectiveId);
    }

    @Override
    public PerspectiveCoordinates withProjectId(@Nonnull ProjectId projectId) {
        if (this.getProjectId().isPresent() && this.getProjectId().get().equals((Object)projectId)) {
            return this;
        }
        return PerspectiveCoordinates.getInternal(this.getProjectIdInternal(), this.getUserIdInternal(), this.getPerspectiveId());
    }

    @JsonProperty(value="projectId")
    @Nullable
    protected abstract ProjectId getProjectIdInternal();

    @JsonIgnore
    @Nonnull
    public Optional<ProjectId> getProjectId() {
        return Optional.ofNullable(this.getProjectIdInternal());
    }

    @JsonProperty(value="projectId")
    @Nullable
    protected abstract UserId getUserIdInternal();

    @JsonIgnore
    @Nonnull
    public Optional<UserId> getUserId() {
        return Optional.ofNullable(this.getUserIdInternal());
    }

    @JsonProperty(value="perspectiveId")
    @Nonnull
    public abstract PerspectiveId getPerspectiveId();
}

