/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.tag;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.tag.TagId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;

public class EntityTags {
    public static final String PROJECT_ID = "projectId";
    public static final String ENTITY = "term";
    public static final String TAGS = "tags";
    private final ProjectId projectId;
    private final OWLEntity entity;
    private final List<TagId> tags;

    public EntityTags(@Nonnull ProjectId projectId, @Nonnull OWLEntity entity, @Nonnull List<TagId> tags) {
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        this.entity = (OWLEntity)Preconditions.checkNotNull((Object)entity);
        this.tags = new ArrayList<TagId>((Collection)Preconditions.checkNotNull(tags));
    }

    @Nonnull
    public ProjectId getProjectId() {
        return this.projectId;
    }

    @Nonnull
    public OWLEntity getEntity() {
        return this.entity;
    }

    @Nonnull
    public List<TagId> getTags() {
        return new ArrayList<TagId>(this.tags);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.entity, this.tags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityTags)) {
            return false;
        }
        EntityTags other = (EntityTags)obj;
        return this.entity.equals(other.entity) && this.projectId.equals((Object)other.projectId) && this.tags.equals(other.tags);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EntityTags").addValue((Object)this.projectId).addValue((Object)this.entity).addValue(this.tags).toString();
    }
}

