/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.viz;

import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.viz.CompositeEdgeCriteria;
import edu.stanford.protege.webprotege.viz.EdgeCriteria;
import edu.stanford.protege.webprotege.viz.NegatedEdgeCriteria;
import edu.stanford.protege.webprotege.viz.SplitEdgeCriteria;
import java.util.Optional;
import javax.annotation.Nonnull;

public class EdgeCriteriaSplitter {
    @Nonnull
    public Optional<SplitEdgeCriteria> splitCriteria(@Nonnull CompositeEdgeCriteria edgeCriteria) {
        ImmutableList<EdgeCriteria> criteriaList = edgeCriteria.getCriteria();
        if (criteriaList.size() != 2) {
            return Optional.empty();
        }
        EdgeCriteria first = (EdgeCriteria)criteriaList.get(0);
        EdgeCriteria second = (EdgeCriteria)criteriaList.get(1);
        if (first instanceof NegatedEdgeCriteria) {
            if (second instanceof NegatedEdgeCriteria) {
                return Optional.empty();
            }
            return this.getSplitCriteria(second, (NegatedEdgeCriteria)first);
        }
        if (second instanceof NegatedEdgeCriteria) {
            return this.getSplitCriteria(first, (NegatedEdgeCriteria)second);
        }
        return Optional.empty();
    }

    private Optional<SplitEdgeCriteria> getSplitCriteria(EdgeCriteria positive, NegatedEdgeCriteria negative) {
        if (!(positive instanceof CompositeEdgeCriteria)) {
            return Optional.empty();
        }
        if (!(negative.getNegatedCriteria() instanceof CompositeEdgeCriteria)) {
            return Optional.empty();
        }
        CompositeEdgeCriteria includeCriteria = (CompositeEdgeCriteria)positive;
        CompositeEdgeCriteria excludeCriteria = (CompositeEdgeCriteria)negative.getNegatedCriteria();
        return Optional.of(SplitEdgeCriteria.get(includeCriteria, excludeCriteria));
    }
}

