/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.webhook;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.webhook.Webhook;
import javax.annotation.Nonnull;

public class SlackWebhook
implements Webhook {
    public static final String PROJECT_ID = "projectId";
    public static final String PAYLOAD_URL = "payloadUrl";
    private final ProjectId projectId;
    private final String payloadUrl;

    public SlackWebhook(@Nonnull ProjectId projectId, @Nonnull String payloadUrl) {
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        this.payloadUrl = (String)Preconditions.checkNotNull((Object)payloadUrl);
    }

    @Nonnull
    public ProjectId getProjectId() {
        return this.projectId;
    }

    @Override
    @Nonnull
    public String getPayloadUrl() {
        return this.payloadUrl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectId, this.payloadUrl});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SlackWebhook)) {
            return false;
        }
        SlackWebhook other = (SlackWebhook)obj;
        return this.projectId.equals((Object)other.projectId) && this.payloadUrl.equals(other.payloadUrl);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SlackWebhook").addValue((Object)this.projectId).add(PAYLOAD_URL, (Object)this.payloadUrl).toString();
    }
}

