/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.hierarchy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class Path<N> {
    private static final Path<?> EMPTY_PATH = new Path();
    private static final transient Transform<?, ?> IDENTITY_TRANSFORM = element -> element;
    private List<N> path = new ArrayList<N>();

    public static <N> Transform<N, N> getIdentityTransform() {
        return IDENTITY_TRANSFORM;
    }

    private Path() {
    }

    @JsonCreator
    public Path(List<N> path) {
        this.path = new ArrayList<N>(path);
    }

    @SafeVarargs
    public static <N> Path<N> asPath(N ... elements) {
        return new Path<N>(Arrays.asList(elements));
    }

    public static <N> Path<N> emptyPath() {
        return EMPTY_PATH;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    @JsonValue
    public List<N> asList() {
        return new ArrayList<N>(this.path);
    }

    @JsonIgnore
    public int getLength() {
        return this.path.size();
    }

    public int size() {
        return this.path.size();
    }

    public N get(int index) {
        return this.path.get(index);
    }

    public boolean contains(N element) {
        return this.path.contains(element);
    }

    @Nonnull
    public Path<N> pathByAppending(@Nonnull N element) {
        ArrayList<N> p = new ArrayList<N>(this.path);
        p.add(Preconditions.checkNotNull(element));
        return new Path<N>(p);
    }

    public <T> Path<T> transform(Transform<N, T> transform) {
        ArrayList<T> result = new ArrayList<T>(this.path.size());
        for (N element : this.path) {
            result.add(transform.transform(element));
        }
        return new Path(result);
    }

    @Nonnull
    public Iterator<N> iterator() {
        return this.path.iterator();
    }

    @JsonIgnore
    public Optional<N> getFirst() {
        if (this.path.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.path.get(0));
    }

    @JsonIgnore
    public Optional<N> getLast() {
        if (this.path.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.path.get(this.path.size() - 1));
    }

    @JsonIgnore
    public Optional<N> getLastPredecessor() {
        if (this.path.size() < 2) {
            return Optional.empty();
        }
        return Optional.of(this.path.get(this.path.size() - 2));
    }

    public Path<N> reverse() {
        return new Path<N>(Lists.reverse(this.path));
    }

    public int hashCode() {
        return "Path".hashCode() + this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        return this.path.equals(other.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Path").addValue(this.path).toString();
    }

    public static interface Transform<N, T> {
        public T transform(N var1);
    }
}

