/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.csv.DocumentId;
import edu.stanford.protege.webprotege.project.AutoValue_NewProjectSettings;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class NewProjectSettings {
    private static final String OWNER = "owner";
    private static final String DISPLAY_NAME = "displayName";
    private static final String LANG_TAG = "langTag";
    private static final String DESCRIPTION = "description";
    private static final String SOURCE_DOCUMENT_ID = "sourceDocumentId";

    @JsonCreator
    public static NewProjectSettings get(@JsonProperty(value="owner") @Nonnull UserId projectOwner, @JsonProperty(value="displayName") @Nonnull String displayName, @JsonProperty(value="langTag") @Nonnull String langTag, @JsonProperty(value="description") @Nonnull String projectDescription, @JsonProperty(value="sourceDocumentId") @Nonnull DocumentId sourceDocumentId) {
        return new AutoValue_NewProjectSettings(projectOwner, displayName, langTag, projectDescription, sourceDocumentId);
    }

    public static NewProjectSettings get(@JsonProperty(value="owner") UserId projectOwner, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="langTag") String langTag, @JsonProperty(value="description") String projectDescription) {
        return new AutoValue_NewProjectSettings(projectOwner, displayName, langTag, projectDescription, null);
    }

    @JsonProperty(value="owner")
    @Nonnull
    public abstract UserId getProjectOwner();

    @JsonProperty(value="displayName")
    @Nonnull
    public abstract String getDisplayName();

    @JsonProperty(value="langTag")
    @Nonnull
    public abstract String getLangTag();

    @JsonProperty(value="description")
    @Nonnull
    public abstract String getProjectDescription();

    @JsonIgnore
    public boolean hasSourceDocument() {
        return this.getSourceDocumentId().isPresent();
    }

    @Nonnull
    public Optional<DocumentId> getSourceDocumentId() {
        return Optional.ofNullable(this.sourceDocument());
    }

    @Nullable
    protected abstract DocumentId sourceDocument();
}

