/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.crud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.crud.EntityCrudKitId;
import edu.stanford.protege.webprotege.crud.EntityCrudKitPrefixSettings;
import edu.stanford.protege.webprotege.crud.EntityCrudKitSuffixSettings;
import edu.stanford.protege.webprotege.crud.gen.GeneratedAnnotationsSettings;
import edu.stanford.protege.webprotege.crud.icatx.IcatxGenerationSuffixKit;
import edu.stanford.protege.webprotege.crud.oboid.OboIdSuffixKit;
import edu.stanford.protege.webprotege.crud.supplied.SuppliedNameSuffixKit;
import edu.stanford.protege.webprotege.crud.uuid.UuidSuffixKit;
import java.io.Serializable;
import java.util.Optional;
import org.semanticweb.owlapi.model.IRI;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=OboIdSuffixKit.class), @JsonSubTypes.Type(value=UuidSuffixKit.class), @JsonSubTypes.Type(value=IcatxGenerationSuffixKit.class), @JsonSubTypes.Type(value=SuppliedNameSuffixKit.class)})
public abstract class EntityCrudKit<S extends EntityCrudKitSuffixSettings>
implements Serializable {
    private EntityCrudKitId kitId;
    private String displayName;

    protected EntityCrudKit() {
    }

    public EntityCrudKit(EntityCrudKitId kitId, String displayName) {
        this.kitId = (EntityCrudKitId)Preconditions.checkNotNull((Object)kitId);
        this.displayName = (String)Preconditions.checkNotNull((Object)displayName);
    }

    @JsonIgnore
    public EntityCrudKitId getKitId() {
        return this.kitId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public abstract EntityCrudKitPrefixSettings getDefaultPrefixSettings();

    public abstract S getDefaultSuffixSettings();

    public abstract Optional<String> getPrefixValidationMessage(String var1);

    public abstract IRI generateExample(EntityCrudKitPrefixSettings var1, S var2);

    public String toString() {
        return MoreObjects.toStringHelper((String)"EntityCrudKit").addValue((Object)this.kitId).add("displayName", (Object)this.displayName).toString();
    }

    public abstract GeneratedAnnotationsSettings getDefaultGeneratedAnnotationsSettings();
}

