/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import org.semanticweb.owlapi.model.EntityType;

public enum PrimitiveType {
    CLASS(EntityType.CLASS),
    NAMED_INDIVIDUAL(EntityType.NAMED_INDIVIDUAL),
    OBJECT_PROPERTY(EntityType.OBJECT_PROPERTY),
    DATA_PROPERTY(EntityType.DATA_PROPERTY),
    ANNOTATION_PROPERTY(EntityType.ANNOTATION_PROPERTY),
    DATA_TYPE(EntityType.DATATYPE),
    LITERAL(null),
    IRI(null);

    private final EntityType<?> entityType;

    private PrimitiveType(EntityType<?> entityType) {
        this.entityType = entityType;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public boolean isEntityType() {
        return this.entityType != null;
    }

    public static PrimitiveType get(EntityType<?> entityType) {
        if (entityType == EntityType.CLASS) {
            return CLASS;
        }
        if (entityType == EntityType.OBJECT_PROPERTY) {
            return OBJECT_PROPERTY;
        }
        if (entityType == EntityType.DATA_PROPERTY) {
            return DATA_PROPERTY;
        }
        if (entityType == EntityType.ANNOTATION_PROPERTY) {
            return ANNOTATION_PROPERTY;
        }
        if (entityType == EntityType.NAMED_INDIVIDUAL) {
            return NAMED_INDIVIDUAL;
        }
        if (entityType == EntityType.DATATYPE) {
            return DATA_TYPE;
        }
        throw new RuntimeException("Unrecognized term type " + String.valueOf(entityType));
    }
}

