/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.hierarchy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import edu.stanford.protege.webprotege.hierarchy.AddEdge;
import edu.stanford.protege.webprotege.hierarchy.GraphEdge;
import edu.stanford.protege.webprotege.hierarchy.GraphModelChange;
import edu.stanford.protege.webprotege.hierarchy.GraphNode;
import edu.stanford.protege.webprotege.hierarchy.RemoveEdge;
import java.util.function.Consumer;

@JsonSubTypes(value={@JsonSubTypes.Type(value=AddEdge.class), @JsonSubTypes.Type(value=RemoveEdge.class)})
public abstract class EdgeChange<U>
extends GraphModelChange<U> {
    private GraphEdge<U> edge;

    protected EdgeChange() {
    }

    protected EdgeChange(GraphEdge<U> edge) {
        this.edge = edge;
    }

    @JsonIgnore
    public GraphNode<U> getPredecessor() {
        return this.edge.getPredecessor();
    }

    @JsonIgnore
    public GraphNode<U> getSuccessor() {
        return this.edge.getSuccessor();
    }

    public GraphEdge<U> getEdge() {
        return this.edge;
    }

    @Override
    void forEachGraphNode(Consumer<GraphNode<U>> nodeConsumer) {
        nodeConsumer.accept(this.edge.getPredecessor());
        nodeConsumer.accept(this.edge.getSuccessor());
    }
}

