/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"prefixName", "prefix"})
public record PrefixDeclaration(@Nonnull String prefixName, @Nonnull String prefix) {
    public PrefixDeclaration(@Nonnull String prefixName, @Nonnull String prefix) {
        this.prefixName = (String)Preconditions.checkNotNull((Object)prefixName);
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix);
        if (!prefixName.endsWith(":")) {
            throw new IllegalArgumentException("Prefix names must end with a colon");
        }
    }

    @JsonIgnore
    public boolean isPrefixWithCommonTerminatingCharacter() {
        return this.prefix.endsWith("/") || this.prefix.endsWith("#") || this.prefix.endsWith("_");
    }

    public static PrefixDeclaration get(String prefixName, String prefix) {
        return new PrefixDeclaration(prefixName, prefix);
    }
}

