/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.project.AutoValue_PrefixDeclarations;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

@AutoValue
public abstract class PrefixDeclarations {
    public static final String PROJECT_ID = "_id";
    public static final String PREFIXES = "prefixes";

    public static PrefixDeclarations get(@Nonnull ProjectId projectId) {
        return new AutoValue_PrefixDeclarations(projectId, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    @JsonCreator
    public static PrefixDeclarations get(@JsonProperty(value="_id") @Nonnull ProjectId projectId, @JsonProperty(value="prefixes") @Nonnull Map<String, String> prefixes) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull(prefixes);
        for (Map.Entry<String, String> entry : prefixes.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("Null prefix names are not allowed");
            }
            if (!entry.getKey().endsWith(":")) {
                throw new IllegalArgumentException("Prefix names must end with a colon");
            }
            if (entry.getValue() != null) continue;
            throw new NullPointerException("Prefixes must not be null.  Prefix pointed to by " + entry.getKey() + " is null.");
        }
        return new AutoValue_PrefixDeclarations(projectId, (ImmutableMap<String, String>)ImmutableMap.copyOf(prefixes));
    }

    @JsonProperty(value="_id")
    @Nonnull
    public abstract ProjectId getProjectId();

    @JsonProperty(value="prefixes")
    @Nonnull
    public abstract ImmutableMap<String, String> getPrefixes();

    @JsonIgnore
    @Nonnull
    public Optional<String> getPrefixForPrefixName(@Nonnull String prefixName) {
        Preconditions.checkArgument((boolean)prefixName.endsWith(":"), (Object)"Prefix names must end with a colon");
        return Optional.ofNullable((String)this.getPrefixes().get((Object)prefixName));
    }
}

