/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.revision;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.revision.RevisionNumber;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class RevisionSummary
implements Serializable,
Comparable<RevisionSummary> {
    private RevisionNumber revisionNumber;
    private UserId userId;
    private long timestamp;
    private int changeCount;
    private String description;

    private RevisionSummary() {
    }

    public RevisionSummary(@Nonnull RevisionNumber revisionNumber, @Nonnull UserId userId, long timestamp, int changeCount, @Nonnull String description) {
        this.revisionNumber = (RevisionNumber)Preconditions.checkNotNull((Object)revisionNumber);
        this.userId = (UserId)Preconditions.checkNotNull((Object)userId);
        this.timestamp = timestamp;
        this.changeCount = changeCount;
        this.description = (String)Preconditions.checkNotNull((Object)description);
    }

    @Nonnull
    public RevisionNumber getRevisionNumber() {
        return this.revisionNumber;
    }

    @Nonnull
    public UserId getUserId() {
        return this.userId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.revisionNumber, this.userId, this.timestamp, this.changeCount, this.description});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RevisionSummary)) {
            return false;
        }
        RevisionSummary other = (RevisionSummary)obj;
        return this.timestamp == other.timestamp && this.revisionNumber.equals(other.revisionNumber) && this.userId.equals((Object)other.userId) && this.changeCount == other.changeCount && this.description.equals(other.description);
    }

    @Override
    public int compareTo(@Nonnull RevisionSummary o) {
        int revNumDiff = this.revisionNumber.compareTo(o.revisionNumber);
        if (revNumDiff != 0) {
            return revNumDiff;
        }
        int userIdDiff = this.userId.compareTo(o.userId);
        if (userIdDiff != 0) {
            return userIdDiff;
        }
        int changeCountDiff = this.changeCount - o.changeCount;
        if (changeCountDiff != 0) {
            return changeCountDiff;
        }
        if (this.timestamp < o.timestamp) {
            return -1;
        }
        if (this.timestamp == o.timestamp) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RevisionSummary").addValue((Object)this.revisionNumber).addValue((Object)this.userId).add("timestamp", this.timestamp).add("changeCount", this.changeCount).add("description", (Object)this.description).toString();
    }
}

