/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.tag;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.color.Color;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.criteria.RootCriteria;
import edu.stanford.protege.webprotege.project.WithProjectId;
import edu.stanford.protege.webprotege.tag.AutoValue_Tag;
import edu.stanford.protege.webprotege.tag.TagId;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class Tag
implements WithProjectId<Tag> {
    public static final String ID = "_id";
    public static final String PROJECT_ID = "projectId";
    public static final String LABEL = "label";
    private static final String DESCRIPTION = "description";
    private static final String COLOR = "color";
    private static final String BACKGROUND_COLOR = "backgroundColor";
    private static final String CRITERIA = "criteria";

    @JsonCreator
    public static Tag get(@Nonnull @JsonProperty(value="_id") TagId tagId, @Nonnull @JsonProperty(value="projectId") ProjectId projectId, @Nonnull @JsonProperty(value="label") String label, @Nonnull @JsonProperty(value="description") String description, @Nonnull @JsonProperty(value="color") Color color, @Nonnull @JsonProperty(value="backgroundColor") Color backgroundColor, @Nullable @JsonProperty(value="criteria") List<RootCriteria> criteria) {
        Preconditions.checkArgument((!label.isEmpty() ? 1 : 0) != 0, (Object)"Tag label cannot be empty");
        ImmutableList rootCriteria = criteria != null ? ImmutableList.copyOf(criteria) : ImmutableList.of();
        return new AutoValue_Tag(tagId, projectId, Objects.requireNonNull(label), Objects.requireNonNull(description), color, backgroundColor, (ImmutableList<RootCriteria>)rootCriteria);
    }

    @JsonProperty(value="_id")
    @Nonnull
    public abstract TagId getTagId();

    @JsonProperty(value="projectId")
    @Nonnull
    public abstract ProjectId getProjectId();

    @JsonProperty(value="label")
    @Nonnull
    public abstract String getLabel();

    @JsonProperty(value="description")
    @Nonnull
    public abstract String getDescription();

    @JsonProperty(value="color")
    @Nonnull
    public abstract Color getColor();

    @JsonProperty(value="backgroundColor")
    @Nonnull
    public abstract Color getBackgroundColor();

    @JsonProperty(value="criteria")
    @Nonnull
    public abstract ImmutableList<RootCriteria> getCriteria();

    @Override
    public Tag withProjectId(@Nonnull ProjectId projectId) {
        return Tag.get(this.getTagId(), projectId, this.getLabel(), this.getDescription(), this.getColor(), this.getBackgroundColor(), this.getCriteria());
    }
}

