/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.viz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.criteria.MultiMatchType;
import edu.stanford.protege.webprotege.viz.AutoValue_EntityGraphFilter;
import edu.stanford.protege.webprotege.viz.CompositeEdgeCriteria;
import edu.stanford.protege.webprotege.viz.EdgeCriteria;
import edu.stanford.protege.webprotege.viz.FilterName;
import edu.stanford.protege.webprotege.viz.NegatedEdgeCriteria;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class EntityGraphFilter {
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String INCLUSION_CRITERIA = "inclusionCriteria";
    private static final String EXCLUSION_CRITERIA = "exclusionCriteria";
    private static final String ACTIVE = "active";

    @JsonCreator
    public static EntityGraphFilter get(@Nonnull @JsonProperty(value="name") FilterName name, @Nullable @JsonProperty(value="description") String description, @Nonnull @JsonProperty(value="inclusionCriteria") CompositeEdgeCriteria inclusionCriteria, @Nonnull @JsonProperty(value="exclusionCriteria") CompositeEdgeCriteria exclusionCriteria, @JsonProperty(value="active") boolean active) {
        return new AutoValue_EntityGraphFilter(name, Objects.requireNonNull(description), inclusionCriteria, exclusionCriteria, active);
    }

    @Nonnull
    @JsonProperty(value="name")
    public abstract FilterName getName();

    @Nonnull
    @JsonProperty(value="description")
    public abstract String getDescription();

    @Nonnull
    @JsonProperty(value="inclusionCriteria")
    public abstract CompositeEdgeCriteria getInclusionCriteria();

    @Nonnull
    @JsonProperty(value="exclusionCriteria")
    public abstract CompositeEdgeCriteria getExclusionCriteria();

    @Nonnull
    public EdgeCriteria getCombinedCriteria() {
        return CompositeEdgeCriteria.get(MultiMatchType.ALL, this.getInclusionCriteria(), NegatedEdgeCriteria.get(this.getExclusionCriteria()));
    }

    @JsonProperty(value="active")
    public abstract boolean isActive();

    @JsonIgnore
    public EntityGraphFilter withActive(boolean active) {
        if (this.isActive() == active) {
            return this;
        }
        return EntityGraphFilter.get(this.getName(), this.getDescription(), this.getInclusionCriteria(), this.getExclusionCriteria(), active);
    }
}

