/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.crud.oboid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.crud.ConditionalIriPrefix;
import edu.stanford.protege.webprotege.crud.EntityCrudKit;
import edu.stanford.protege.webprotege.crud.EntityCrudKitId;
import edu.stanford.protege.webprotege.crud.EntityCrudKitPrefixSettings;
import edu.stanford.protege.webprotege.crud.gen.GeneratedAnnotationsSettings;
import edu.stanford.protege.webprotege.crud.oboid.OboIdSuffixSettings;
import java.util.Optional;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.IRI;

@JsonTypeName(value="OboId")
public class OboIdSuffixKit
extends EntityCrudKit<OboIdSuffixSettings> {
    public static final String DEFAULT_PREFIX = "http://purl.obolibrary.org/obo/ONT_";
    private static final EntityCrudKitId ID = EntityCrudKitId.get("OBO");

    @Inject
    public OboIdSuffixKit() {
        super(ID, "Auto-generated  OBO Style Id");
    }

    @JsonIgnore
    public static EntityCrudKitId getId() {
        return ID;
    }

    @Override
    public EntityCrudKitPrefixSettings getDefaultPrefixSettings() {
        return EntityCrudKitPrefixSettings.get(DEFAULT_PREFIX, (ImmutableList<ConditionalIriPrefix>)ImmutableList.of());
    }

    @Override
    public OboIdSuffixSettings getDefaultSuffixSettings() {
        return OboIdSuffixSettings.get();
    }

    @Override
    public Optional<String> getPrefixValidationMessage(String prefix) {
        if (prefix.endsWith(DEFAULT_PREFIX)) {
            return Optional.of("The default prefix is specified.  You should change this to suit your ontology.");
        }
        if (!prefix.endsWith("_")) {
            return Optional.of("OBO IRI prefixes should end with an underscore");
        }
        return Optional.empty();
    }

    @Override
    public IRI generateExample(EntityCrudKitPrefixSettings prefixSettings, OboIdSuffixSettings suffixSettings) {
        StringBuilder sb = new StringBuilder();
        sb.append("0".repeat(Math.max(0, suffixSettings.getTotalDigits() - 1)));
        sb.append("1");
        return IRI.create((String)prefixSettings.getIRIPrefix(), (String)sb.toString());
    }

    @Override
    public GeneratedAnnotationsSettings getDefaultGeneratedAnnotationsSettings() {
        return GeneratedAnnotationsSettings.empty();
    }
}

