/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.DictionaryLanguageData;
import edu.stanford.protege.webprotege.common.ShortForm;
import edu.stanford.protege.webprotege.entity.AutoValue_EntityNode;
import edu.stanford.protege.webprotege.entity.EntityStatus;
import edu.stanford.protege.webprotege.entity.OWLEntityData;
import edu.stanford.protege.webprotege.tag.Tag;
import edu.stanford.protege.webprotege.watches.Watch;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;

@AutoValue
public abstract class EntityNode
implements Serializable,
Comparable<EntityNode> {
    private static final boolean NOT_DEPRECATED = false;
    private static final ImmutableSet<Watch> NO_WATCHES = ImmutableSet.of();
    private static final int NO_OPEN_COMMENTS = 0;
    private static final ImmutableSet<Tag> NO_ENTITY_TAGS = ImmutableSet.of();
    private static final ImmutableSet<EntityStatus> NO_STATUSES = ImmutableSet.of();

    @Nonnull
    public static EntityNode get(@Nonnull OWLEntity entity, @Nonnull String browserText, @Nonnull ImmutableMap<DictionaryLanguage, String> shortForms, boolean deprecated, @Nonnull Set<Watch> watches, int openCommentCount, Collection<Tag> tags, Set<EntityStatus> statuses) {
        return new AutoValue_EntityNode(entity, browserText, (ImmutableSet<Tag>)ImmutableSet.copyOf(tags), deprecated, (ImmutableSet<Watch>)ImmutableSet.copyOf(watches), openCommentCount, shortForms, (ImmutableSet<EntityStatus>)ImmutableSet.copyOf(statuses));
    }

    @JsonCreator
    @Nonnull
    public static EntityNode get(@JsonProperty(value="entity") @Nonnull OWLEntity entity, @JsonProperty(value="browserText") @Nonnull String browserText, @JsonProperty(value="shortForms") @Nonnull ImmutableList<ShortForm> shortForms, @JsonProperty(value="deprecated") boolean deprecated, @JsonProperty(value="watches") @Nonnull Set<Watch> watches, @JsonProperty(value="openCommentCount") int openCommentCount, @JsonProperty(value="tags") Collection<Tag> tags, @JsonProperty(value="statuses") Set<EntityStatus> statuses) {
        ImmutableMap map = (ImmutableMap)shortForms.stream().collect(ImmutableMap.toImmutableMap(ShortForm::getDictionaryLanguage, ShortForm::getShortForm));
        return EntityNode.get(entity, browserText, (ImmutableMap<DictionaryLanguage, String>)map, deprecated, (Set<Watch>)ImmutableSet.copyOf(watches), openCommentCount, (Collection<Tag>)ImmutableSet.copyOf(tags), (Set<EntityStatus>)ImmutableSet.copyOf(statuses));
    }

    @Nonnull
    public static EntityNode getFromEntityData(@Nonnull OWLEntityData entityData) {
        return EntityNode.get(entityData.getEntity(), entityData.getBrowserText(), (ImmutableList<ShortForm>)entityData.getShortForms(), false, NO_WATCHES, 0, NO_ENTITY_TAGS, NO_STATUSES);
    }

    @Nonnull
    public abstract OWLEntity getEntity();

    @Nonnull
    public abstract String getBrowserText();

    @JsonIgnore
    @Nonnull
    public String getText() {
        return this.getBrowserText();
    }

    public String getText(@Nonnull DictionaryLanguageData prefLang) {
        return this.getText(Collections.singletonList(prefLang.getDictionaryLanguage()), this.getBrowserText());
    }

    public String getText(@Nonnull List<DictionaryLanguage> prefLang, String defaultText) {
        return prefLang.stream().map(language -> (String)this.getShortForms().get(language)).filter(Objects::nonNull).findFirst().orElse(defaultText);
    }

    public abstract ImmutableSet<Tag> getTags();

    public abstract boolean isDeprecated();

    public abstract ImmutableSet<Watch> getWatches();

    public abstract int getOpenCommentCount();

    @JsonIgnore
    @Nonnull
    public abstract ImmutableMap<DictionaryLanguage, String> getShortForms();

    @JsonProperty(value="statuses")
    public abstract ImmutableSet<EntityStatus> getStatuses();

    @JsonProperty(value="shortForms")
    public ImmutableList<ShortForm> getShortFormsList() {
        return (ImmutableList)this.getShortForms().entrySet().stream().map(entry -> ShortForm.get((DictionaryLanguage)((DictionaryLanguage)entry.getKey()), (String)((String)entry.getValue()))).collect(ImmutableList.toImmutableList());
    }

    @Override
    public int compareTo(EntityNode o) {
        return this.getBrowserText().compareToIgnoreCase(o.getBrowserText());
    }
}

