/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.issues;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.issues.CommentId;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Comment {
    private CommentId id;
    private UserId createdBy;
    private long createdAt;
    @Nullable
    private Long updatedAt;
    private String body;
    @Nullable
    private String renderedBody;

    public Comment(@Nonnull CommentId id, @Nonnull UserId createdBy, long createdAt, @Nonnull Optional<Long> updatedAt, @Nonnull String body, @Nonnull String renderedBody) {
        this(id, createdBy, createdAt, (Long)((Optional)Preconditions.checkNotNull(updatedAt)).orElse(null), (String)Preconditions.checkNotNull((Object)body), (String)Preconditions.checkNotNull((Object)renderedBody));
    }

    private Comment(@Nonnull CommentId id, @Nonnull UserId createdBy, long createdAt, @Nullable Long updatedAt, @Nonnull String body, @Nullable String renderedBody) {
        this.id = (CommentId)Preconditions.checkNotNull((Object)id);
        this.createdBy = (UserId)Preconditions.checkNotNull((Object)createdBy);
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.body = (String)Preconditions.checkNotNull((Object)body);
        this.renderedBody = renderedBody;
    }

    private Comment() {
    }

    @Nonnull
    public CommentId getId() {
        return this.id;
    }

    @Nonnull
    public UserId getCreatedBy() {
        return this.createdBy;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    public Optional<Long> getUpdatedAt() {
        return Optional.ofNullable(this.updatedAt);
    }

    @Nonnull
    public String getBody() {
        return this.body;
    }

    @Nonnull
    public String getRenderedBody() {
        if (this.renderedBody == null) {
            return this.body;
        }
        return this.renderedBody;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)obj;
        return this.id.equals(other.id) && this.createdBy.equals((Object)other.createdBy) && this.createdAt == other.createdAt && Objects.equal((Object)this.updatedAt, (Object)other.updatedAt) && this.body.equals(other.body) && Objects.equal((Object)this.renderedBody, (Object)other.renderedBody);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.createdAt, this.createdBy, this.updatedAt, this.body});
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Comment").addValue((Object)this.id).add("createdBy", (Object)this.createdBy).add("createdAt", this.createdAt).add("updatedAt", (Object)this.updatedAt).add("body", (Object)this.body).toString();
    }
}

