/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.common.LangTagFilter;
import edu.stanford.protege.webprotege.common.PageRequest;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.criteria.EntityMatchCriteria;
import edu.stanford.protege.webprotege.criteria.EntityTypeIsOneOfCriteria;
import edu.stanford.protege.webprotege.dispatch.ProjectAction;
import edu.stanford.protege.webprotege.project.HasProjectId;
import edu.stanford.protege.webprotege.search.EntitySearchFilter;
import edu.stanford.protege.webprotege.search.PerformEntitySearchResult;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.EntityType;

@JsonTypeName(value="webprotege.search.PerformEntitySearch")
public record PerformEntitySearchAction(@JsonProperty(value="projectId", required=true) @Nonnull ProjectId projectId, @JsonProperty(value="searchString", required=true) @Nonnull String searchString, @JsonProperty(value="entityTypes", defaultValue="[]") @Nonnull Set<EntityType<?>> entityTypes, @JsonProperty(value="langTagFilter") @Nonnull LangTagFilter langTagFilter, @JsonProperty(value="searchFilters") @Nonnull ImmutableList<EntitySearchFilter> searchFilters, @JsonProperty(value="pageRequest") @Nonnull PageRequest pageRequest, @JsonProperty(value="resultsSetFilter") @Nullable EntityMatchCriteria resultsSetFilter) implements ProjectAction<PerformEntitySearchResult>,
HasProjectId
{
    public static final String CHANNEL = "webprotege.search.PerformEntitySearch";

    public PerformEntitySearchAction(@JsonProperty(value="projectId") @Nonnull ProjectId projectId, @JsonProperty(value="searchString") @Nonnull String searchString, @JsonProperty(value="entityTypes") @Nonnull Set<EntityType<?>> entityTypes, @JsonProperty(value="langTagFilter") @Nonnull LangTagFilter langTagFilter, @JsonProperty(value="searchFilters") @Nonnull ImmutableList<EntitySearchFilter> searchFilters, @JsonProperty(value="pageRequest") @Nonnull PageRequest pageRequest, @JsonProperty(value="resultsSetFilter") @Nullable EntityMatchCriteria resultsSetFilter) {
        this.projectId = Objects.requireNonNull(projectId);
        this.searchString = Objects.requireNonNull(searchString);
        this.entityTypes = Objects.requireNonNullElse(entityTypes, Collections.emptySet());
        this.langTagFilter = Objects.requireNonNullElse(langTagFilter, LangTagFilter.get((ImmutableSet)ImmutableSet.of()));
        this.searchFilters = Objects.requireNonNullElse(searchFilters, ImmutableList.of());
        this.pageRequest = Objects.requireNonNullElse(pageRequest, PageRequest.requestFirstPage());
        this.resultsSetFilter = (EntityMatchCriteria)Objects.requireNonNullElse(resultsSetFilter, EntityTypeIsOneOfCriteria.get((ImmutableSet)ImmutableSet.copyOf(entityTypes)));
    }

    public PerformEntitySearchAction(@Nonnull ProjectId projectId, @Nonnull String searchString, @Nonnull Set<EntityType<?>> entityTypes, @Nonnull LangTagFilter langTagFilter, @Nonnull ImmutableList<EntitySearchFilter> searchFilters, @Nonnull PageRequest pageRequest) {
        this(projectId, searchString, entityTypes, langTagFilter, searchFilters, pageRequest, null);
    }

    public String getChannel() {
        return CHANNEL;
    }
}

