/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.app;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.app.ApplicationLocation;
import javax.annotation.Nonnull;

public class ApplicationPreferences {
    public static final String ID = "Preferences";
    private final String id = "Preferences";
    private final String applicationName;
    private final String systemNotificationEmailAddress;
    private final ApplicationLocation applicationLocation;
    private final long maxUploadSize;

    public ApplicationPreferences(@Nonnull String applicationName, @Nonnull String systemNotificationEmailAddress, @Nonnull ApplicationLocation applicationLocation, long maxUploadSize) {
        this.applicationName = (String)Preconditions.checkNotNull((Object)applicationName);
        this.systemNotificationEmailAddress = (String)Preconditions.checkNotNull((Object)systemNotificationEmailAddress);
        this.applicationLocation = (ApplicationLocation)Preconditions.checkNotNull((Object)applicationLocation);
        this.maxUploadSize = maxUploadSize;
    }

    @Nonnull
    public String getApplicationName() {
        return this.applicationName;
    }

    @Nonnull
    public String getSystemNotificationEmailAddress() {
        return this.systemNotificationEmailAddress;
    }

    @Nonnull
    public ApplicationLocation getApplicationLocation() {
        return this.applicationLocation;
    }

    public long getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.applicationName, this.systemNotificationEmailAddress, this.applicationLocation, this.maxUploadSize});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationPreferences)) {
            return false;
        }
        ApplicationPreferences other = (ApplicationPreferences)obj;
        return this.applicationName.equals(other.applicationName) && this.systemNotificationEmailAddress.equals(other.systemNotificationEmailAddress) && this.applicationLocation.equals(other.applicationLocation) && this.maxUploadSize == other.maxUploadSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ApplicationPreferences").addValue((Object)this.applicationName).add("systemNotificationEmail", (Object)this.systemNotificationEmailAddress).addValue((Object)this.applicationLocation).toString();
    }
}

