/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.crud;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

public class PrefixedNameExpander {
    private final ImmutableMap<String, String> prefixName2PrefixMap;

    private PrefixedNameExpander(ImmutableMap<String, String> prefixName2PrefixMap) {
        this.prefixName2PrefixMap = (ImmutableMap)Preconditions.checkNotNull(prefixName2PrefixMap);
    }

    public Optional<IRI> getExpandedPrefixName(String suppliedName) {
        Preconditions.checkNotNull((Object)suppliedName);
        int prefixNameSeparatorIndex = suppliedName.indexOf(58);
        if (prefixNameSeparatorIndex == -1) {
            return Optional.empty();
        }
        String suppliedPrefixName = suppliedName.substring(0, prefixNameSeparatorIndex + 1);
        if (suppliedPrefixName.isEmpty()) {
            return Optional.empty();
        }
        if (prefixNameSeparatorIndex + 1 >= suppliedName.length()) {
            return Optional.empty();
        }
        String prefix = (String)this.prefixName2PrefixMap.get((Object)suppliedPrefixName);
        if (prefix == null) {
            return Optional.empty();
        }
        String suffix = suppliedName.substring(suppliedPrefixName.length());
        String fullIRI = prefix + suffix;
        return Optional.of(IRI.create((String)fullIRI));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> prefixName2PrefixMap = Maps.newHashMap();

        public PrefixedNameExpander build() {
            return new PrefixedNameExpander((ImmutableMap<String, String>)ImmutableMap.copyOf(this.prefixName2PrefixMap));
        }

        public Builder withPrefixNamePrefix(String prefixName, String prefix) {
            Preconditions.checkNotNull((Object)prefixName);
            Preconditions.checkNotNull((Object)prefix);
            this.checkPrefixNameEndsWithColon(prefixName);
            this.checkPrefixNameContainsExactlyOneColon(prefixName, prefix);
            this.prefixName2PrefixMap.put(prefixName, prefix);
            return this;
        }

        public Builder withNamespaces(Namespaces[] namespaces) {
            Preconditions.checkNotNull((Object)namespaces);
            for (Namespaces ns : namespaces) {
                this.withPrefixNamePrefix(ns.getPrefixName() + ":", ns.getPrefixIRI());
            }
            return this;
        }

        private void checkPrefixNameContainsExactlyOneColon(String prefixName, String prefix) {
            Preconditions.checkArgument((prefixName.indexOf(":") == prefixName.length() - 1 ? 1 : 0) != 0, (Object)"prefixName must only contain one colon");
        }

        private void checkPrefixNameEndsWithColon(String prefixName) {
            Preconditions.checkArgument((boolean)prefixName.endsWith(":"), (Object)"prefixName must end with colon");
        }
    }
}

