/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.perspective;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.perspective.AutoValue_PerspectiveLayoutRecord;
import edu.stanford.protege.webprotege.perspective.Node;
import edu.stanford.protege.webprotege.perspective.PerspectiveId;
import edu.stanford.protege.webprotege.perspective.PerspectiveLayout;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class PerspectiveLayoutRecord {
    public static final String PROJECT_ID = "projectId";
    public static final String USER_ID = "userId";
    public static final String PERSPECTIVE_ID = "perspectiveId";
    public static final String LAYOUT = "layout";

    @JsonCreator
    @Nonnull
    protected static PerspectiveLayoutRecord get(@JsonProperty(value="projectId") @Nullable ProjectId projectId, @JsonProperty(value="userId") @Nullable UserId userId, @JsonProperty(value="perspectiveId") @Nonnull PerspectiveId perspectiveId, @JsonProperty(value="layout") @Nullable Node layout) {
        return new AutoValue_PerspectiveLayoutRecord(projectId, userId, perspectiveId, layout);
    }

    @JsonProperty(value="projectId")
    @Nullable
    public abstract ProjectId getProjectId();

    @JsonProperty(value="userId")
    @Nullable
    public abstract UserId getUserId();

    @JsonProperty(value="perspectiveId")
    @Nonnull
    public abstract PerspectiveId getPerspectiveId();

    @JsonProperty(value="layout")
    @Nullable
    public abstract Node getLayout();

    @Nonnull
    public PerspectiveLayout toPerspectiveLayout() {
        Node layout = this.getLayout();
        if (layout != null) {
            return PerspectiveLayout.get(this.getPerspectiveId(), layout);
        }
        return PerspectiveLayout.get(this.getPerspectiveId());
    }
}

