/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.projectsettings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.crud.EntityCrudKitSettings;
import edu.stanford.protege.webprotege.project.PrefixDeclaration;
import edu.stanford.protege.webprotege.project.WithProjectId;
import edu.stanford.protege.webprotege.projectsettings.AutoValue_AllProjectSettings;
import edu.stanford.protege.webprotege.projectsettings.ProjectSettings;
import edu.stanford.protege.webprotege.search.ProjectSearchSettings;
import edu.stanford.protege.webprotege.sharing.ProjectSharingSettings;
import edu.stanford.protege.webprotege.tag.Tag;
import javax.annotation.Nonnull;

@AutoValue
public abstract class AllProjectSettings
implements WithProjectId<AllProjectSettings> {
    public static final String PROJECT_SETTINGS = "projectSettings";
    public static final String ENTITY_CREATION_SETTINGS = "entityCreationSettings";
    public static final String PREFIX_DECLARATIONS = "prefixDeclarations";
    public static final String PROJECT_TAGS = "projectTags";
    public static final String SHARING_SETTINGS = "sharingSettings";
    public static final String SEARCH_SETTINGS = "searchSettings";

    @JsonCreator
    @Nonnull
    public static AllProjectSettings get(@JsonProperty(value="projectSettings") @Nonnull ProjectSettings projectSettings, @JsonProperty(value="entityCreationSettings") @Nonnull EntityCrudKitSettings entityCrudKitSettings, @JsonProperty(value="prefixDeclarations") @Nonnull ImmutableList<PrefixDeclaration> prefixDeclarations, @JsonProperty(value="projectTags") @Nonnull ImmutableList<Tag> tags, @JsonProperty(value="sharingSettings") @Nonnull ProjectSharingSettings projectSharingSettings, @JsonProperty(value="searchSettings") @Nonnull ProjectSearchSettings projectSearchSettings) {
        return new AutoValue_AllProjectSettings(projectSettings, entityCrudKitSettings, prefixDeclarations, tags, projectSharingSettings, projectSearchSettings);
    }

    @JsonProperty(value="projectSettings")
    @Nonnull
    public abstract ProjectSettings getProjectSettings();

    @JsonProperty(value="entityCreationSettings")
    @Nonnull
    public abstract EntityCrudKitSettings getEntityCreationSettings();

    @JsonProperty(value="prefixDeclarations")
    @Nonnull
    public abstract ImmutableList<PrefixDeclaration> getPrefixDeclarations();

    @JsonProperty(value="projectTags")
    @Nonnull
    public abstract ImmutableList<Tag> getProjectTags();

    @JsonProperty(value="sharingSettings")
    @Nonnull
    public abstract ProjectSharingSettings getSharingSettings();

    @JsonProperty(value="searchSettings")
    @Nonnull
    public abstract ProjectSearchSettings getSearchSettings();

    @Override
    public AllProjectSettings withProjectId(@Nonnull ProjectId projectId) {
        return AllProjectSettings.get(this.getProjectSettings().withProjectId(projectId), this.getEntityCreationSettings(), this.getPrefixDeclarations(), (ImmutableList<Tag>)((ImmutableList)this.getProjectTags().stream().map(t -> t.withProjectId(projectId)).collect(ImmutableList.toImmutableList())), this.getSharingSettings(), this.getSearchSettings());
    }
}

