/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.search;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.search.AutoValue_EntityNameMatchResult;
import edu.stanford.protege.webprotege.search.EntityNameMatchType;
import edu.stanford.protege.webprotege.search.PrefixNameMatchType;
import javax.annotation.Nonnull;

@AutoValue
public abstract class EntityNameMatchResult
implements Comparable<EntityNameMatchResult> {
    public static EntityNameMatchResult get(int start, int end, EntityNameMatchType matchType, PrefixNameMatchType prefixNameMatchType) {
        Preconditions.checkArgument((start > -1 ? 1 : 0) != 0);
        Preconditions.checkArgument((end > -1 ? 1 : 0) != 0);
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0);
        return new AutoValue_EntityNameMatchResult(start, end, matchType, prefixNameMatchType);
    }

    public abstract int getStart();

    public abstract int getEnd();

    public abstract EntityNameMatchType getMatchType();

    public abstract PrefixNameMatchType getPrefixNameMatchType();

    @Override
    public int compareTo(@Nonnull EntityNameMatchResult entityNameMatchResult) {
        int typeDiff = this.getMatchType().compareTo(entityNameMatchResult.getMatchType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        int prefixNameMatchTypeDiff = this.getPrefixNameMatchType().compareTo(entityNameMatchResult.getPrefixNameMatchType());
        if (prefixNameMatchTypeDiff != 0) {
            return prefixNameMatchTypeDiff;
        }
        int startDiff = this.getStart() - entityNameMatchResult.getStart();
        if (startDiff != 0) {
            return startDiff;
        }
        return this.getEnd() - entityNameMatchResult.getEnd();
    }
}

