/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.usage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Optional;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLEntity;

public class UsageReference
implements Serializable,
Comparable<UsageReference> {
    private AxiomType axiomType;
    private String axiomRendering;
    private OWLEntity subject;
    private String subjectRendering;

    private UsageReference() {
    }

    @JsonCreator
    public UsageReference(@JsonProperty(value="axiomType") AxiomType<?> axiomType, @JsonProperty(value="axiomRendering") String axiomRendering, @JsonProperty(value="axiomSubject") Optional<OWLEntity> axiomSubject, @JsonProperty(value="subjectRendering") Optional<String> subjectRendering) {
        this.subject = ((Optional)Preconditions.checkNotNull(axiomSubject)).orElse(null);
        this.subjectRendering = subjectRendering.orElse("");
        this.axiomType = (AxiomType)Preconditions.checkNotNull(axiomType);
        this.axiomRendering = (String)Preconditions.checkNotNull((Object)axiomRendering);
    }

    public String getSubjectRendering() {
        return this.subjectRendering;
    }

    public Optional<OWLEntity> getAxiomSubject() {
        return Optional.ofNullable(this.subject);
    }

    public AxiomType getAxiomType() {
        return this.axiomType;
    }

    public String getAxiomRendering() {
        return this.axiomRendering;
    }

    public int hashCode() {
        return "UsageReference".hashCode() + Optional.ofNullable(this.subject).hashCode() + this.axiomType.hashCode() + this.axiomRendering.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UsageReference)) {
            return false;
        }
        UsageReference other = (UsageReference)obj;
        return Optional.ofNullable(this.subject).equals(Optional.ofNullable(other.subject)) && this.axiomType.equals((Object)other.axiomType) && this.axiomRendering.equals(other.axiomRendering);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UsageReference");
        sb.append("(Subject(");
        sb.append(this.subject);
        sb.append(") AxiomType(");
        sb.append(this.axiomType);
        sb.append(") AxiomRendering(");
        sb.append(this.axiomRendering);
        sb.append("))");
        return sb.toString();
    }

    @Override
    public int compareTo(UsageReference o) {
        int subjectDiff;
        if (this.subject == null) {
            if (o.subject != null) {
                return 1;
            }
        } else if (o.subject == null) {
            return -1;
        }
        if ((subjectDiff = this.subjectRendering.compareTo(o.subjectRendering)) != 0) {
            return subjectDiff;
        }
        int axiomTypeDiff = this.axiomType.getIndex() - o.axiomType.getIndex();
        if (axiomTypeDiff != 0) {
            return axiomTypeDiff;
        }
        return this.axiomRendering.compareTo(o.axiomRendering);
    }
}

