/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.viz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import edu.stanford.protege.webprotege.viz.EntityGraphFilter;
import edu.stanford.protege.webprotege.viz.EntityGraphSettings;
import javax.annotation.Nonnull;

final class AutoValue_EntityGraphSettings
extends EntityGraphSettings {
    private final ImmutableList<EntityGraphFilter> filters;
    private final double rankSpacing;

    AutoValue_EntityGraphSettings(ImmutableList<EntityGraphFilter> filters, double rankSpacing) {
        if (filters == null) {
            throw new NullPointerException("Null filters");
        }
        this.filters = filters;
        this.rankSpacing = rankSpacing;
    }

    @Override
    @Nonnull
    @JsonProperty(value="filters")
    public ImmutableList<EntityGraphFilter> getFilters() {
        return this.filters;
    }

    @Override
    @JsonProperty(value="rankSpacing")
    public double getRankSpacing() {
        return this.rankSpacing;
    }

    public String toString() {
        return "EntityGraphSettings{filters=" + String.valueOf(this.filters) + ", rankSpacing=" + this.rankSpacing + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EntityGraphSettings) {
            EntityGraphSettings that = (EntityGraphSettings)o;
            return this.filters.equals(that.getFilters()) && Double.doubleToLongBits(this.rankSpacing) == Double.doubleToLongBits(that.getRankSpacing());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.filters.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(Double.doubleToLongBits(this.rankSpacing) >>> 32 ^ Double.doubleToLongBits(this.rankSpacing));
    }
}

