/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.webhook;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.project.HasProjectId;
import edu.stanford.protege.webprotege.webhook.ProjectWebhookEventType;
import edu.stanford.protege.webprotege.webhook.Webhook;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ProjectWebhook
implements Webhook,
HasProjectId {
    public static final String PROJECT_ID = "projectId";
    public static final String SUBSCRIBED_TO_EVENTS = "subscribedToEvents";
    private final ProjectId projectId;
    private final String payloadUrl;
    private List<ProjectWebhookEventType> subscribedToEvents = new ArrayList<ProjectWebhookEventType>();

    public ProjectWebhook(ProjectId projectId, String payloadUrl, List<ProjectWebhookEventType> subscribedToEvents) {
        this.projectId = (ProjectId)Preconditions.checkNotNull((Object)projectId);
        this.payloadUrl = (String)Preconditions.checkNotNull((Object)payloadUrl);
        this.subscribedToEvents = new ArrayList<ProjectWebhookEventType>(subscribedToEvents);
    }

    @Override
    @Nonnull
    public ProjectId projectId() {
        return this.projectId;
    }

    @Override
    @Nonnull
    public String getPayloadUrl() {
        return this.payloadUrl;
    }

    @Nonnull
    public List<ProjectWebhookEventType> getSubscribedToEvents() {
        return new ArrayList<ProjectWebhookEventType>(this.subscribedToEvents);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectId, this.payloadUrl, this.subscribedToEvents});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProjectWebhook)) {
            return false;
        }
        ProjectWebhook other = (ProjectWebhook)obj;
        return this.projectId.equals((Object)other.projectId) && this.payloadUrl.equals(other.payloadUrl) && this.subscribedToEvents.equals(other.subscribedToEvents);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProjectWebhook").addValue((Object)this.payloadUrl).add("payloadUrl", (Object)this.payloadUrl).add(SUBSCRIBED_TO_EVENTS, this.subscribedToEvents).toString();
    }
}

