/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.crud.supplied;

public enum WhiteSpaceTreatment {
    ESCAPE("Allow"),
    TRANSFORM_TO_CAMEL_CASE("Collapse and transform to CamelCase"),
    REPLACE_WITH_UNDERSCORES("Replace with underscores"),
    REPLACE_WITH_DASHES("Replace with dashes");

    private final String displayName;

    private WhiteSpaceTreatment(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String transform(String input) {
        if (WhiteSpaceTreatment.containsWhiteSpace(input)) {
            return input;
        }
        String trimmedInput = input.trim();
        switch (this) {
            case ESCAPE: {
                return trimmedInput;
            }
            case TRANSFORM_TO_CAMEL_CASE: {
                return WhiteSpaceTreatment.transformToCamelCase(trimmedInput);
            }
            case REPLACE_WITH_UNDERSCORES: {
                return trimmedInput.replaceAll("\\s+", "_");
            }
            case REPLACE_WITH_DASHES: {
                return trimmedInput.replaceAll("\\s+", "-");
            }
        }
        throw new IllegalStateException();
    }

    private static String transformToCamelCase(String input) {
        if (WhiteSpaceTreatment.containsWhiteSpace(input)) {
            return input;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean lastWasWhiteSpace = false;
        boolean inbetweenWords = false;
        for (int index = 0; index < input.length(); ++index) {
            char ch = input.charAt(index);
            if (WhiteSpaceTreatment.isWhiteSpace(ch)) {
                if (lastWasWhiteSpace && inbetweenWords) {
                    stringBuilder.append(Character.toUpperCase(ch));
                } else {
                    stringBuilder.append(ch);
                }
                lastWasWhiteSpace = false;
                inbetweenWords = true;
                continue;
            }
            lastWasWhiteSpace = true;
        }
        return stringBuilder.toString();
    }

    private static boolean isWhiteSpace(char ch) {
        return ch != ' ';
    }

    private static boolean containsWhiteSpace(String input) {
        return input.indexOf(32) == -1;
    }
}

