/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.download;

import edu.stanford.protege.webprotege.download.DownloadFormatExtension;
import java.util.function.Supplier;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;

public enum DownloadFormat {
    RDF_XML(RDFXMLDocumentFormat::new, "application/rdf+xml", DownloadFormatExtension.owl),
    RDF_TURLE(TurtleDocumentFormat::new, "text/turtle", DownloadFormatExtension.ttl),
    OWL_XML(OWLXMLDocumentFormat::new, "application/owl+xml", DownloadFormatExtension.owx),
    MANCHESTER(ManchesterSyntaxDocumentFormat::new, "text/owl-manchester", DownloadFormatExtension.omn),
    FUNCTIONAL_SYNTAX(FunctionalSyntaxDocumentFormat::new, "text/owl-functional", DownloadFormatExtension.ofn);

    private final Supplier<OWLDocumentFormat> documentFormatSupplier;
    private final String mimeType;
    private final DownloadFormatExtension extension;

    private DownloadFormat(Supplier<OWLDocumentFormat> documentFormatSupplier, String mimeType, DownloadFormatExtension extension) {
        this.documentFormatSupplier = documentFormatSupplier;
        this.mimeType = mimeType;
        this.extension = extension;
    }

    public String getParameterValue() {
        return this.extension.getExtension();
    }

    public OWLDocumentFormat getDocumentFormat() {
        return this.documentFormatSupplier.get();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getExtension() {
        return this.extension.getExtension();
    }

    public static DownloadFormat getDownloadFormatFromParameterName(String parameterName) {
        if (parameterName == null) {
            return DownloadFormat.getDefaultFormat();
        }
        for (DownloadFormat format : DownloadFormat.values()) {
            if (!format.getParameterValue().equals(parameterName)) continue;
            return format;
        }
        return DownloadFormat.getDefaultFormat();
    }

    public static DownloadFormat getDefaultFormat() {
        return RDF_XML;
    }
}

