/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.common.EntityStatus;
import edu.stanford.protege.webprotege.entity.EntityNode;
import edu.stanford.protege.webprotege.tag.Tag;
import edu.stanford.protege.webprotege.watches.Watch;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;

final class AutoValue_EntityNode
extends EntityNode {
    private final OWLEntity entity;
    private final String browserText;
    private final ImmutableSet<Tag> tags;
    private final boolean deprecated;
    private final ImmutableSet<Watch> watches;
    private final int openCommentCount;
    private final ImmutableMap<DictionaryLanguage, String> shortForms;
    private final ImmutableSet<EntityStatus> statuses;

    AutoValue_EntityNode(OWLEntity entity, String browserText, ImmutableSet<Tag> tags, boolean deprecated, ImmutableSet<Watch> watches, int openCommentCount, ImmutableMap<DictionaryLanguage, String> shortForms, ImmutableSet<EntityStatus> statuses) {
        if (entity == null) {
            throw new NullPointerException("Null entity");
        }
        this.entity = entity;
        if (browserText == null) {
            throw new NullPointerException("Null browserText");
        }
        this.browserText = browserText;
        if (tags == null) {
            throw new NullPointerException("Null tags");
        }
        this.tags = tags;
        this.deprecated = deprecated;
        if (watches == null) {
            throw new NullPointerException("Null watches");
        }
        this.watches = watches;
        this.openCommentCount = openCommentCount;
        if (shortForms == null) {
            throw new NullPointerException("Null shortForms");
        }
        this.shortForms = shortForms;
        if (statuses == null) {
            throw new NullPointerException("Null statuses");
        }
        this.statuses = statuses;
    }

    @Override
    @Nonnull
    public OWLEntity getEntity() {
        return this.entity;
    }

    @Override
    @Nonnull
    public String getBrowserText() {
        return this.browserText;
    }

    @Override
    public ImmutableSet<Tag> getTags() {
        return this.tags;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public ImmutableSet<Watch> getWatches() {
        return this.watches;
    }

    @Override
    public int getOpenCommentCount() {
        return this.openCommentCount;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public ImmutableMap<DictionaryLanguage, String> getShortForms() {
        return this.shortForms;
    }

    @Override
    @JsonProperty(value="statuses")
    public ImmutableSet<EntityStatus> getStatuses() {
        return this.statuses;
    }

    public String toString() {
        return "EntityNode{entity=" + String.valueOf(this.entity) + ", browserText=" + this.browserText + ", tags=" + String.valueOf(this.tags) + ", deprecated=" + this.deprecated + ", watches=" + String.valueOf(this.watches) + ", openCommentCount=" + this.openCommentCount + ", shortForms=" + String.valueOf(this.shortForms) + ", statuses=" + String.valueOf(this.statuses) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EntityNode) {
            EntityNode that = (EntityNode)o;
            return this.entity.equals(that.getEntity()) && this.browserText.equals(that.getBrowserText()) && this.tags.equals(that.getTags()) && this.deprecated == that.isDeprecated() && this.watches.equals(that.getWatches()) && this.openCommentCount == that.getOpenCommentCount() && this.shortForms.equals(that.getShortForms()) && this.statuses.equals(that.getStatuses());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.entity.hashCode();
        h$ *= 1000003;
        h$ ^= this.browserText.hashCode();
        h$ *= 1000003;
        h$ ^= this.tags.hashCode();
        h$ *= 1000003;
        h$ ^= this.deprecated ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.watches.hashCode();
        h$ *= 1000003;
        h$ ^= this.openCommentCount;
        h$ *= 1000003;
        h$ ^= this.shortForms.hashCode();
        h$ *= 1000003;
        return h$ ^= this.statuses.hashCode();
    }
}

