/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.lang;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import edu.stanford.protege.webprotege.common.DictionaryLanguage;
import edu.stanford.protege.webprotege.lang.AutoValue_DisplayNameSettings;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AutoValue
public abstract class DisplayNameSettings {
    private static final String PRIMARY_DISPLAY_NAME_LANGUAGES = "primaryDisplayNameLanguages";
    private static final String SECONDARY_DISPLAY_NAME_LANGUAGES = "secondaryDisplayNameLanguages";

    @JsonCreator
    @Nonnull
    public static DisplayNameSettings get(@Nullable @JsonProperty(value="primaryDisplayNameLanguages") ImmutableList<DictionaryLanguage> primaryLanguages, @Nullable @JsonProperty(value="secondaryDisplayNameLanguages") ImmutableList<DictionaryLanguage> secondaryLanguages) {
        return new AutoValue_DisplayNameSettings(primaryLanguages == null ? ImmutableList.of() : primaryLanguages, secondaryLanguages == null ? ImmutableList.of() : secondaryLanguages);
    }

    @Nonnull
    public static DisplayNameSettings empty() {
        return DisplayNameSettings.get((ImmutableList<DictionaryLanguage>)ImmutableList.of(), (ImmutableList<DictionaryLanguage>)ImmutableList.of());
    }

    @JsonProperty(value="primaryDisplayNameLanguages")
    @Nonnull
    public abstract ImmutableList<DictionaryLanguage> getPrimaryDisplayNameLanguages();

    @JsonProperty(value="secondaryDisplayNameLanguages")
    @Nonnull
    public abstract ImmutableList<DictionaryLanguage> getSecondaryDisplayNameLanguages();

    public boolean hasDisplayNameLanguageForLangTag(@Nonnull String langTag) {
        Stream languages = Streams.concat((Stream[])new Stream[]{this.getPrimaryDisplayNameLanguages().stream(), this.getSecondaryDisplayNameLanguages().stream()});
        return languages.anyMatch(l -> langTag.equalsIgnoreCase(l.getLang()));
    }
}

