/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.lang;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class LanguageCode
implements Comparable<LanguageCode> {
    private final String lang;
    private final String name;

    public LanguageCode(String lang, String name) {
        this.lang = (String)Preconditions.checkNotNull((Object)lang);
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public String getLang() {
        return this.lang;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(LanguageCode o) {
        return this.getLang().compareToIgnoreCase(o.lang);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.lang, this.name});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LanguageCode)) {
            return false;
        }
        LanguageCode other = (LanguageCode)obj;
        return this.lang.equals(other.lang) && this.name.equals(other.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LanguageCode").addValue((Object)this.lang).addValue((Object)this.name).toString();
    }
}

