/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.mansyntax;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.mansyntax.AutoCompletionChoice;
import edu.stanford.protege.webprotege.mansyntax.EditorPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoCompletionResult {
    private static final AutoCompletionResult EMPTY_RESULT = new AutoCompletionResult();
    private final List<AutoCompletionChoice> choices;
    private final EditorPosition fromPosition;

    public AutoCompletionResult() {
        this(new ArrayList<AutoCompletionChoice>(), new EditorPosition(0, 0));
    }

    @JsonCreator
    public AutoCompletionResult(@JsonProperty(value="choices") List<AutoCompletionChoice> choices, @JsonProperty(value="fromPosition") EditorPosition fromPosition) {
        this.choices = new ArrayList<AutoCompletionChoice>((Collection)Preconditions.checkNotNull(choices));
        this.fromPosition = (EditorPosition)Preconditions.checkNotNull((Object)fromPosition);
    }

    public EditorPosition getFromPosition() {
        return this.fromPosition;
    }

    public List<AutoCompletionChoice> getChoices() {
        return new ArrayList<AutoCompletionChoice>(this.choices);
    }

    public static AutoCompletionResult emptyResult() {
        return EMPTY_RESULT;
    }

    public int hashCode() {
        return "AutoCompletionResult".hashCode() + this.choices.hashCode() + this.fromPosition.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoCompletionResult)) {
            return false;
        }
        AutoCompletionResult other = (AutoCompletionResult)o;
        return this.fromPosition.equals(other.fromPosition) && this.choices.equals(other.choices);
    }
}

