/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.perspective;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.UUIDUtil;
import edu.stanford.protege.webprotege.perspective.AutoValue_PerspectiveId;
import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Nonnull;

@AutoValue
public abstract class PerspectiveId
implements Serializable {
    @JsonCreator
    @Nonnull
    public static PerspectiveId get(@Nonnull String id) {
        if (!UUIDUtil.isWellFormed((String)id)) {
            throw new IllegalArgumentException("Malformed PerspectiveId.  PerspectiveIds must be UUIDs");
        }
        return new AutoValue_PerspectiveId(id);
    }

    @Nonnull
    public static PerspectiveId generate() {
        return PerspectiveId.get(UUID.randomUUID().toString());
    }

    @JsonValue
    @Nonnull
    public abstract String getId();

    @JsonIgnore
    public String value() {
        return this.getId();
    }
}

