/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.perspective;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.perspective.Node;
import edu.stanford.protege.webprotege.perspective.NodeProperties;
import edu.stanford.protege.webprotege.perspective.NodeVisitor;
import edu.stanford.protege.webprotege.perspective.TerminalNodeId;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"id", "properties"})
@JsonTypeName(value="LeafNode")
public class TerminalNode
extends Node {
    private NodeProperties nodeProperties;
    private final TerminalNodeId nodeId;

    public TerminalNode() {
        this(TerminalNodeId.get());
    }

    public TerminalNode(TerminalNodeId nodeId) {
        this(nodeId, NodeProperties.emptyNodeProperties());
    }

    @JsonCreator
    public TerminalNode(@JsonProperty(value="id") TerminalNodeId nodeId, @JsonProperty(value="properties") NodeProperties nodeProperties) {
        this.nodeId = nodeId == null ? TerminalNodeId.get() : nodeId;
        this.nodeProperties = nodeProperties == null ? NodeProperties.emptyNodeProperties() : (NodeProperties)Preconditions.checkNotNull((Object)nodeProperties);
    }

    @JsonProperty(value="id")
    public TerminalNodeId getNodeId() {
        return this.nodeId;
    }

    @JsonProperty(value="properties")
    public NodeProperties getNodeProperties() {
        return this.nodeProperties;
    }

    public void setNodeProperties(@Nonnull NodeProperties nodeProperties) {
        this.nodeProperties = (NodeProperties)Preconditions.checkNotNull((Object)nodeProperties);
    }

    @Override
    public <O> O accept(NodeVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public TerminalNode duplicate() {
        TerminalNode result = new TerminalNode(this.nodeId);
        result.setParent(this.getParent());
        result.nodeProperties = this.nodeProperties;
        return result;
    }

    @Override
    public boolean isIsometricWith(Node otherNode) {
        return otherNode instanceof TerminalNode;
    }

    @Override
    @JsonIgnore
    public boolean isParentNode() {
        return false;
    }

    @Override
    public Node minimise() {
        return this;
    }

    @Override
    @JsonIgnore
    public Set<TerminalNode> getTerminalNodes() {
        return Collections.singleton(this);
    }

    public int hashCode() {
        return "TerminalNode".hashCode() + this.nodeId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TerminalNode)) {
            return false;
        }
        TerminalNode other = (TerminalNode)o;
        return this.nodeId.equals(other.nodeId);
    }

    @Override
    public boolean equalsIgnoreWeights(Node other) {
        return this.equals(other);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TerminalNode").addValue((Object)this.nodeId).addValue((Object)this.nodeProperties).toString();
    }
}

