/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.auto.value.AutoValue;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.common.UserId;
import edu.stanford.protege.webprotege.project.AutoValue_AvailableProject;
import edu.stanford.protege.webprotege.project.HasProjectId;
import java.util.Comparator;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"projectId", "displayName", "description", "owner", "createdAt", "createdBy", "lastModifiedAt", "lastModifiedBy", "inTrash", "trashable", "downloadable"})
@AutoValue
public abstract class AvailableProject
implements HasProjectId,
Comparable<AvailableProject> {
    public static final long UNKNOWN = 0L;
    private static final Comparator<AvailableProject> COMPARATOR = Comparator.comparing(ap -> ap.getDisplayName().toLowerCase());

    @JsonCreator
    public static AvailableProject get(@JsonProperty(value="projectId") @Nonnull ProjectId projectId, @JsonProperty(value="displayName") @Nonnull String displayName, @JsonProperty(value="description") @Nonnull String description, @JsonProperty(value="owner") @Nonnull UserId owner, @JsonProperty(value="inTrash") boolean inTrash, @JsonProperty(value="createdAt") long createdAt, @JsonProperty(value="createdBy") @Nonnull UserId createdBy, @JsonProperty(value="lastModifiedAt") long lastModifiedAt, @JsonProperty(value="lastModifiedBy") @Nonnull UserId lastModifiedBy, @JsonProperty(value="downloadable") boolean downloadable, @JsonProperty(value="trashable") boolean trashable, @JsonProperty(value="lastOpenedAt") long lastOpenedTimestamp) {
        return new AutoValue_AvailableProject(projectId, displayName, owner, description, inTrash, createdAt, createdBy, lastModifiedAt, lastModifiedBy, downloadable, trashable, lastOpenedTimestamp);
    }

    @Override
    @Nonnull
    @JsonProperty(value="projectId")
    public abstract ProjectId projectId();

    @Nonnull
    public abstract String getDisplayName();

    @Nonnull
    public abstract UserId getOwner();

    @Nonnull
    public abstract String getDescription();

    public abstract boolean isInTrash();

    public abstract long getCreatedAt();

    @Nonnull
    public abstract UserId getCreatedBy();

    public abstract long getLastModifiedAt();

    @Nonnull
    public abstract UserId getLastModifiedBy();

    public abstract boolean isDownloadable();

    public abstract boolean isTrashable();

    public abstract long getLastOpenedAt();

    @Override
    public int compareTo(AvailableProject o) {
        return COMPARATOR.compare(this, o);
    }
}

