/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.tag;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.stanford.protege.webprotege.common.UUIDUtil;
import edu.stanford.protege.webprotege.common.ValueObject;
import java.util.UUID;
import javax.annotation.Nonnull;

public class TagId
implements ValueObject {
    private String id;

    private TagId(@Nonnull String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    private TagId() {
    }

    @JsonCreator
    @Nonnull
    public static TagId getId(@Nonnull String id) {
        if (!UUIDUtil.isWellFormed((String)((String)Preconditions.checkNotNull((Object)id)))) {
            throw new IllegalArgumentException("Malformed tag id: " + id);
        }
        return new TagId(id);
    }

    public static TagId valueOf(String id) {
        return TagId.getId(id);
    }

    public String value() {
        return this.id;
    }

    public static TagId createTagId() {
        return TagId.getId(UUID.randomUUID().toString());
    }

    @JsonValue
    @Nonnull
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TagId)) {
            return false;
        }
        TagId other = (TagId)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TagId").addValue((Object)this.id).toString();
    }
}

