/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.usage;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonTypeName;
import edu.stanford.protege.webprotege.common.PageRequest;
import edu.stanford.protege.webprotege.common.ProjectId;
import edu.stanford.protege.webprotege.dispatch.ProjectAction;
import edu.stanford.protege.webprotege.usage.GetEntityUsageResult;
import edu.stanford.protege.webprotege.usage.UsageFilter;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLEntity;

@JsonTypeName(value="webprotege.entities.GetEntityUsage")
@JsonClassDescription(value="Requests the entity usage for the specified entity.  The usage is the set of OWL axioms that mention the entity in their signature.")
public record GetEntityUsageAction(@JsonPropertyDescription(value="The entity whose usage will be returned") OWLEntity subject, @JsonPropertyDescription(value="The project id in which the entity is used") ProjectId projectId, @JsonPropertyDescription(value="The usage filter that specifies they types of axioms to be retrieved etc.") @Nullable UsageFilter usageFilter, @Nonnull PageRequest pageRequest) implements ProjectAction<GetEntityUsageResult>
{
    public static final String CHANNEL = "webprotege.entities.GetEntityUsage";

    public String getChannel() {
        return CHANNEL;
    }

    public Optional<UsageFilter> getUsageFilter() {
        return Optional.ofNullable(this.usageFilter);
    }
}

