/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.protege.webprotege.usage;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;

public class UsageFilter
implements Serializable {
    private boolean showDefiningAxioms = true;
    private final Set<AxiomType<?>> axiomTypes;
    private final Set<EntityType<?>> entityTypes;

    public UsageFilter() {
        this.axiomTypes = new HashSet();
        this.entityTypes = new HashSet();
    }

    public UsageFilter(boolean showDefiningAxioms, Set<EntityType<?>> entityTypes, Set<AxiomType<?>> axiomTypes) {
        this.showDefiningAxioms = showDefiningAxioms;
        this.axiomTypes = new HashSet(axiomTypes);
        this.entityTypes = new HashSet(entityTypes);
    }

    public Set<AxiomType<?>> getAxiomTypes() {
        return this.axiomTypes;
    }

    public Set<EntityType<?>> getEntityTypes() {
        return this.entityTypes;
    }

    public boolean isShowDefiningAxioms() {
        return this.showDefiningAxioms;
    }

    public boolean isFiltering() {
        return !this.showDefiningAxioms || !this.axiomTypes.containsAll(AxiomType.AXIOM_TYPES) || !this.entityTypes.containsAll(EntityType.values());
    }

    public boolean isIncluded(AxiomType<?> axiomType) {
        return this.axiomTypes.isEmpty() || this.axiomTypes.contains(axiomType);
    }

    public boolean isIncluded(EntityType<?> entityType) {
        return this.entityTypes.isEmpty() || this.entityTypes.contains(entityType);
    }
}

